/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.atomtype;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.atomtype.IAtomTypeMatcher;
import org.openscience.cdk.atomtype.mapper.AtomTypeMapper;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;

@TestClass(value="org.openscience.cdk.atomtype.SybylAtomTypeMatcherTest")
public class SybylAtomTypeMatcher
implements IAtomTypeMatcher {
    private static final String SYBYL_ATOM_TYPE_LIST = "org/openscience/cdk/dict/data/sybyl-atom-types.owl";
    private static final String CDK_TO_SYBYL_MAP = "org/openscience/cdk/dict/data/cdk-sybyl-mappings.owl";
    private AtomTypeFactory factory;
    private CDKAtomTypeMatcher cdkMatcher;
    private AtomTypeMapper mapper;
    private static Map<IChemObjectBuilder, SybylAtomTypeMatcher> factories = new Hashtable<IChemObjectBuilder, SybylAtomTypeMatcher>(1);

    private SybylAtomTypeMatcher(IChemObjectBuilder builder) {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(SYBYL_ATOM_TYPE_LIST);
        this.factory = AtomTypeFactory.getInstance(stream, "owl", builder);
        this.cdkMatcher = CDKAtomTypeMatcher.getInstance(builder);
        InputStream mapStream = this.getClass().getClassLoader().getResourceAsStream(CDK_TO_SYBYL_MAP);
        this.mapper = AtomTypeMapper.getInstance(CDK_TO_SYBYL_MAP, mapStream);
    }

    @TestMethod(value="testGetInstance_IChemObjectBuilder")
    public static SybylAtomTypeMatcher getInstance(IChemObjectBuilder builder) {
        if (!factories.containsKey(builder)) {
            factories.put(builder, new SybylAtomTypeMatcher(builder));
        }
        return factories.get(builder);
    }

    @TestMethod(value="testFindMatchingAtomType_IAtomContainer")
    public IAtomType[] findMatchingAtomType(IAtomContainer atomContainer) throws CDKException {
        Iterator<IAtom> i$ = atomContainer.atoms().iterator();
        while (i$.hasNext()) {
            IAtom atom;
            IAtomType type = this.cdkMatcher.findMatchingAtomType(atomContainer, atom = i$.next());
            atom.setAtomTypeName(type == null ? null : type.getAtomTypeName());
            atom.setHybridization(type == null ? null : type.getHybridization());
        }
        CDKHueckelAromaticityDetector.detectAromaticity(atomContainer);
        IAtomType[] types = new IAtomType[atomContainer.getAtomCount()];
        int typeCounter = 0;
        for (IAtom atom : atomContainer.atoms()) {
            String mappedType = this.mapCDKToSybylType(atom);
            types[typeCounter] = mappedType == null ? null : this.factory.getAtomType(mappedType);
            ++typeCounter;
        }
        return types;
    }

    @TestMethod(value="testFindMatchingAtomType_IAtomContainer_IAtom")
    public IAtomType findMatchingAtomType(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type = this.cdkMatcher.findMatchingAtomType(atomContainer, atom);
        if (type == null) {
            return null;
        }
        atom.setAtomTypeName(type.getAtomTypeName());
        String mappedType = this.mapCDKToSybylType(atom);
        if (mappedType == null) {
            return null;
        }
        return this.factory.getAtomType(mappedType);
    }

    private String mapCDKToSybylType(IAtom atom) {
        String typeName = atom.getAtomTypeName();
        if (typeName == null) {
            return null;
        }
        String mappedType = this.mapper.mapAtomType(typeName);
        if ("C.2".equals(mappedType) && atom.getFlag(32)) {
            mappedType = "C.ar";
        } else if ("N.2".equals(mappedType) && atom.getFlag(32)) {
            mappedType = "N.ar";
        } else if ("N.pl3".equals(mappedType) && atom.getFlag(32)) {
            mappedType = "N.ar";
        }
        return mappedType;
    }
}

