/*
 * Decompiled with CFR 0.152.
 */
package signature.chemistry;

import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import signature.ColoredTree;
import signature.SymmetryClass;
import signature.chemistry.AtomPermutor;
import signature.chemistry.AtomSignature;
import signature.chemistry.Molecule;
import signature.chemistry.MoleculeBuilder;
import signature.chemistry.MoleculeFactory;
import signature.chemistry.MoleculeReader;
import signature.chemistry.MoleculeSignature;

public class MoleculeSignatureTest {
    @Test
    public void minimalTest() {
        Molecule molecule = new Molecule();
        molecule.addAtom(0, "C");
        molecule.addAtom(1, "N");
        molecule.addAtom(2, "Cl");
        molecule.addAtom(3, "O");
        molecule.addBond(0, 1, 1);
        molecule.addBond(1, 2, 1);
        molecule.addBond(1, 3, 1);
        MoleculeSignature signature = new MoleculeSignature(molecule);
        String moleculeSignature = signature.getGraphSignature();
        Molecule permutation = new Molecule();
        permutation.addAtom(0, "C");
        permutation.addAtom(1, "N");
        permutation.addAtom(2, "O");
        permutation.addAtom(3, "Cl");
        permutation.addBond(0, 1, 1);
        permutation.addBond(1, 2, 1);
        permutation.addBond(1, 3, 1);
        MoleculeSignature permSignature = new MoleculeSignature(molecule);
        String permSignatureString = permSignature.getGraphSignature();
        Assert.assertEquals((String)moleculeSignature, (String)permSignatureString);
    }

    @Test
    public void testColoredTreeCreation() {
        String signatureString = "[C]([C]([C,1])[C]([C,1]))";
        ColoredTree tree = AtomSignature.parse(signatureString);
        Assert.assertEquals((String)signatureString, (String)tree.toString());
    }

    @Test
    public void testOddCycleReadin() {
        String signatureString = "[C]([C]([C,2]([C,1]))[C]([C,1]))";
        ColoredTree tree = AtomSignature.parse(signatureString);
        Assert.assertEquals((String)signatureString, (String)tree.toString());
        Molecule molecule = new MoleculeBuilder().fromTree(tree);
        Assert.assertEquals((int)5, (int)molecule.getAtomCount());
        Assert.assertEquals((int)5, (int)molecule.getBondCount());
    }

    @Test
    public void testCage() {
        String signatureString = "[C]([C]([C,2]([C]([C,3][C,4]))[C]([C,5][C,3]([C,6]([C,1]))))[C]([C]([C,7][C]([C,1][C,8]))[C,5]([C,8]([C,6])))[C]([C,2][C,7]([C,4]([C,1]))))";
        ColoredTree tree = AtomSignature.parse(signatureString);
        Assert.assertEquals((String)signatureString, (String)tree.toString());
        Molecule molecule = new MoleculeBuilder().fromTree(tree);
        Assert.assertEquals((int)16, (int)molecule.getAtomCount());
        Assert.assertEquals((int)24, (int)molecule.getBondCount());
    }

    @Test
    public void testRoundtrip() {
        Molecule molecule = new Molecule();
        molecule.addAtom("C");
        molecule.addAtom("C");
        molecule.addAtom("C");
        molecule.addAtom("C");
        molecule.addBond(0, 1, 1);
        molecule.addBond(0, 3, 1);
        molecule.addBond(1, 2, 1);
        molecule.addBond(2, 3, 1);
        AtomSignature atomSignature = new AtomSignature(molecule, 0);
        String signatureString = atomSignature.toCanonicalString();
        ColoredTree tree = AtomSignature.parse(signatureString);
        MoleculeBuilder builder = new MoleculeBuilder();
        Molecule builtMolecule = builder.fromTree(tree);
        Assert.assertEquals((String)molecule.toString(), (String)builtMolecule.toString());
    }

    @Test
    public void testLargeExample() {
        String filename = "data/large_example.sdf";
        for (Molecule molecule : MoleculeReader.readSDFFile(filename)) {
            MoleculeSignature signature = new MoleculeSignature(molecule);
            System.out.println(signature.getGraphSignature());
        }
    }

    @Test
    public void testSDF() {
        String filename = "data/test.sdf";
        int molNr = 0;
        for (Molecule molecule : MoleculeReader.readSDFFile(filename)) {
            System.out.println(++molNr);
            MoleculeSignature signature = new MoleculeSignature(molecule);
            System.out.println(signature.getGraphSignature());
        }
    }

    @Test
    public void testCanonicalLabelling() {
        String filename = "data/multCycle.sdf";
        for (Molecule molecule : MoleculeReader.readSDFFile(filename)) {
            MoleculeSignature signature = new MoleculeSignature(molecule);
            System.out.println(molecule.getAtomCount());
            Assert.assertEquals((boolean)false, (boolean)signature.isCanonicallyLabelled());
        }
        String filenameCanLabel = "data/multCycleCanLabel.sdf";
        for (Molecule molecule : MoleculeReader.readSDFFile(filenameCanLabel)) {
            MoleculeSignature signatureCanLabel = new MoleculeSignature(molecule);
            Assert.assertEquals((boolean)true, (boolean)signatureCanLabel.isCanonicallyLabelled());
        }
    }

    public void testCanonicalIsUnique(Molecule molecule) {
        System.out.println("isUnique?" + molecule);
        AtomPermutor permutor = new AtomPermutor(molecule);
        String canonicalStringForm = null;
        boolean isUnique = true;
        boolean atLeastOneCanonicalExample = false;
        MoleculeSignature initialMolSig = new MoleculeSignature(molecule);
        if (initialMolSig.isCanonicallyLabelled()) {
            atLeastOneCanonicalExample = true;
            canonicalStringForm = initialMolSig.reconstructCanonicalEdgeString();
        }
        while (permutor.hasNext()) {
            Molecule permutation = permutor.next();
            MoleculeSignature molSig = new MoleculeSignature(permutation);
            if (!molSig.isCanonicallyLabelled()) continue;
            String stringForm = molSig.reconstructCanonicalEdgeString();
            if (canonicalStringForm == null) {
                canonicalStringForm = stringForm;
                atLeastOneCanonicalExample = true;
                continue;
            }
            if (canonicalStringForm.equals(stringForm)) continue;
            isUnique = false;
            break;
        }
        Assert.assertTrue((String)"Canonical example is not unique", (boolean)isUnique);
        Assert.assertTrue((String)"No canonical example", (boolean)atLeastOneCanonicalExample);
    }

    @Test
    public void testFiveCycle() {
        Molecule molecule = MoleculeFactory.fiveCycle();
        AtomSignature atomSignature = new AtomSignature(molecule, 0);
        System.out.println(atomSignature.toCanonicalString());
    }

    @Test
    public void testThreeStarCanonicalUnique() {
        Molecule molecule = MoleculeFactory.threeStar();
        this.testCanonicalIsUnique(molecule);
    }

    @Test
    public void testFourStarCanonicalUnique() {
        Molecule molecule = MoleculeFactory.fourStar();
        this.testCanonicalIsUnique(molecule);
    }

    @Test
    public void testFiveStarCanonicalUnique() {
        Molecule molecule = MoleculeFactory.fiveStar();
        this.testCanonicalIsUnique(molecule);
    }

    @Test
    public void testTriangleCanonicalIsUnique() {
        Molecule molecule = MoleculeFactory.threeCycle();
        this.testCanonicalIsUnique(molecule);
    }

    @Test
    public void testSquareCanonicalIsUnique() {
        Molecule molecule = MoleculeFactory.fourCycle();
        this.testCanonicalIsUnique(molecule);
    }

    @Test
    public void testPentagonCanonicalIsUnique() {
        Molecule molecule = MoleculeFactory.fiveCycle();
        this.testCanonicalIsUnique(molecule);
    }

    @Test
    public void testHexagonCanonicalIsUnique() {
        Molecule molecule = MoleculeFactory.sixCycle();
        this.testCanonicalIsUnique(molecule);
    }

    @Test
    public void testPropellaneCanonicalIsUnique() {
        Molecule molecule = MoleculeFactory.propellane();
        this.testCanonicalIsUnique(molecule);
    }

    @Test
    public void testPseudopropellaneCanonicalIsUnique() {
        Molecule molecule = MoleculeFactory.pseudopropellane();
        this.testCanonicalIsUnique(molecule);
    }

    @Test
    public void testMethylCyclobutaneCanonicalIsUnique() {
        Molecule molecule = MoleculeFactory.methylatedCyclobutane();
        this.testCanonicalIsUnique(molecule);
    }

    @Test
    public void testSixcageCanonicalIsUnique() {
        Molecule molecule = MoleculeFactory.sixCage();
        this.testCanonicalIsUnique(molecule);
    }

    @Test
    public void testCarbonChainUnique() {
        Molecule a = new Molecule("C", 1);
        this.testCanonicalIsUnique(a);
        a.addAtom("C");
        a.addSingleBond(0, 1);
        this.testCanonicalIsUnique(a);
        a.addAtom("C");
        a.addSingleBond(0, 2);
        this.testCanonicalIsUnique(a);
        Molecule b = new Molecule(a);
        Molecule c = new Molecule(a);
        a.addAtom("C");
        a.addSingleBond(1, 3);
        this.testCanonicalIsUnique(a);
        b.addAtom("C");
        b.addSingleBond(0, 3);
        this.testCanonicalIsUnique(b);
        c.addSingleBond(1, 2);
        this.testCanonicalIsUnique(c);
    }

    @Test
    public void testCarbonHydrogenCanonicalChain() {
        Molecule a = new Molecule("C", 1);
        this.testCanonicalIsUnique(a);
        a.addAtom("H");
        a.addSingleBond(0, 1);
        this.testCanonicalIsUnique(a);
        a.addAtom("H");
        a.addSingleBond(0, 2);
        this.testCanonicalIsUnique(a);
        a.addAtom("H");
        a.addSingleBond(0, 3);
        this.testCanonicalIsUnique(a);
        a.addAtom("H");
        a.addSingleBond(0, 4);
        this.testCanonicalIsUnique(a);
    }

    @Test
    public void testMetheneFragmentIsCanonicallyUnique() {
        Molecule molecule = new Molecule();
        molecule.addAtom("C");
        molecule.addAtom("H");
        molecule.addAtom("H");
        molecule.addSingleBond(0, 1);
        molecule.addSingleBond(0, 2);
        this.testCanonicalIsUnique(molecule);
    }

    @Test
    public void testMethaneIsCanonicallyUnique() {
        Molecule molecule = MoleculeFactory.methane();
        this.testCanonicalIsUnique(molecule);
    }

    @Test
    public void testMethaneSignatures() {
        Molecule molecule = MoleculeFactory.methane();
        MoleculeSignature signature = new MoleculeSignature(molecule);
        List<SymmetryClass> symmetryClasses = signature.getSymmetryClasses();
        Assert.assertEquals((int)2, (int)symmetryClasses.size());
        for (SymmetryClass symmetryClass : symmetryClasses) {
            if (symmetryClass.getSignatureString().startsWith("[H")) {
                Assert.assertEquals((int)4, (int)symmetryClass.size());
                continue;
            }
            Assert.assertEquals((int)1, (int)symmetryClass.size());
        }
    }

    @Test
    public void testMetheneFragmentSignatures() {
        Molecule molecule = new Molecule();
        molecule.addAtom("C");
        molecule.addAtom("H");
        molecule.addAtom("H");
        molecule.addSingleBond(0, 1);
        molecule.addSingleBond(0, 2);
        MoleculeSignature signature = new MoleculeSignature(molecule);
        List<SymmetryClass> symmetryClasses = signature.getSymmetryClasses();
        Assert.assertEquals((int)2, (int)symmetryClasses.size());
        for (SymmetryClass symmetryClass : symmetryClasses) {
            if (symmetryClass.getSignatureString().startsWith("[H")) {
                Assert.assertEquals((int)2, (int)symmetryClass.size());
                continue;
            }
            Assert.assertEquals((int)1, (int)symmetryClass.size());
        }
    }

    @Test
    public void testMethyneFragmentSignatures() {
        Molecule molecule = new Molecule();
        molecule.addAtom("C");
        molecule.addAtom("H");
        molecule.addSingleBond(0, 1);
        MoleculeSignature signature = new MoleculeSignature(molecule);
        List<SymmetryClass> symmetryClasses = signature.getSymmetryClasses();
        Assert.assertEquals((int)2, (int)symmetryClasses.size());
        for (SymmetryClass symmetryClass : symmetryClasses) {
            Assert.assertEquals((int)1, (int)symmetryClass.size());
        }
    }

    @Test
    public void testCanonicalIsUnique() {
        Molecule molecule = new Molecule();
        molecule.addAtom("C");
        molecule.addAtom("C");
        molecule.addAtom("C");
        molecule.addAtom("C");
        molecule.addAtom("C");
        molecule.addAtom("C");
        molecule.addBond(0, 1, 1);
        molecule.addBond(1, 2, 1);
        molecule.addBond(1, 3, 1);
        molecule.addBond(2, 4, 1);
        molecule.addBond(2, 5, 1);
        this.testCanonicalIsUnique(molecule);
    }
}

