/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers;

import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;

public class QueryAtomContainer
extends AtomContainer
implements IQueryAtomContainer {
    private static final long serialVersionUID = -1876912362585898476L;

    @Override
    public void add(IAtomContainer container) {
        if (!(container instanceof QueryAtomContainer)) {
            throw new IllegalArgumentException("AtomContainer is not of type QueryAtomContainer");
        }
        super.add(container);
    }

    @Override
    public void addAtom(IAtom atom) {
        if (!(atom instanceof IQueryAtom)) {
            throw new IllegalArgumentException("Atom is not of type QueryAtom");
        }
        super.addAtom(atom);
    }

    @Override
    public void addBond(IBond bond) {
        if (!(bond instanceof IQueryBond)) {
            throw new IllegalArgumentException("Bond is not of type QueryBond");
        }
        super.addBond(bond);
    }

    @Override
    public String toString() {
        int i;
        StringBuffer s = new StringBuffer();
        s.append("QueryAtomContainer(");
        s.append(this.hashCode() + ", ");
        s.append("#A:" + this.getAtomCount() + ", ");
        s.append("#EC:" + this.getElectronContainerCount() + ", ");
        for (i = 0; i < this.getAtomCount(); ++i) {
            s.append(this.getAtom(i).toString() + ", ");
        }
        for (i = 0; i < this.getBondCount(); ++i) {
            s.append(this.getBond(i).toString() + ", ");
        }
        for (i = 0; i < this.getLonePairCount(); ++i) {
            s.append(this.getLonePair(i).toString() + ", ");
        }
        for (i = 0; i < this.getSingleElectronCount(); ++i) {
            s.append(this.getSingleElectron(i).toString() + ", ");
        }
        s.append(")");
        return s.toString();
    }
}

