/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.CTXFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.BondManipulator;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

@TestClass(value="org.openscience.cdk.io.CTXReaderTest")
public class CTXReader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(CTXReader.class);
    private IChemFile file = null;

    public CTXReader() {
    }

    public CTXReader(Reader input) {
        this();
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public CTXReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return CTXFormat.getInstance();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader reader) throws CDKException {
        this.input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    @Override
    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IChemFile.class.equals(interfaces[i])) continue;
            return true;
        }
        Class superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            this.file = (IChemFile)object;
            return (T)this.readChemFile();
        }
        throw new CDKException("Only supported is reading of ChemFile.");
    }

    private IChemFile readChemFile() throws CDKException {
        IChemSequence seq = this.file.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel model = this.file.getBuilder().newInstance(IChemModel.class, new Object[0]);
        IMoleculeSet containerSet = this.file.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
        IMolecule container = this.file.getBuilder().newInstance(IMolecule.class, new Object[0]);
        int lineNumber = 0;
        try {
            String line = this.input.readLine();
            while (this.input.ready() && line != null) {
                logger.debug(lineNumber++ + ": ", line);
                String command = null;
                if (this.isCommand(line)) {
                    command = this.getCommand(line);
                    int lineCount = this.getContentLinesCount(line);
                    if ("ATOMS".equals(command)) {
                        this.processAtomsBlock(lineCount, container);
                    } else if ("BONDS".equals(command)) {
                        this.processBondsBlock(lineCount, container);
                    } else if ("IDENT".equals(command)) {
                        this.processIdentBlock(lineCount, container);
                    } else if ("NAME".equals(command)) {
                        this.processNameBlock(lineCount, container);
                    } else {
                        logger.warn("Dropping block: ", command);
                        for (int i = 0; i < lineCount; ++i) {
                            this.input.readLine();
                        }
                    }
                } else {
                    logger.warn("Unexpected content at line: ", lineNumber);
                }
                line = this.input.readLine();
            }
            containerSet.addAtomContainer(container);
            model.setMoleculeSet(containerSet);
            seq.addChemModel(model);
            this.file.addChemSequence(seq);
        }
        catch (Exception exception) {
            String message = "Error while parsing CTX file: " + exception.getMessage();
            logger.error(message);
            logger.debug(exception);
            throw new CDKException(message, exception);
        }
        return this.file;
    }

    private void processIdentBlock(int lineCount, IAtomContainer container) throws IOException {
        String identifier = "";
        for (int i = 0; i < lineCount; ++i) {
            identifier = identifier + this.input.readLine().trim();
        }
        container.setID(identifier);
    }

    private void processNameBlock(int lineCount, IAtomContainer container) throws IOException {
        String name = "";
        for (int i = 0; i < lineCount; ++i) {
            name = name + this.input.readLine().trim();
        }
        container.setProperty("cdk:Title", name);
    }

    private void processAtomsBlock(int lineCount, IAtomContainer container) throws IOException {
        for (int i = 0; i < lineCount; ++i) {
            String line = this.input.readLine();
            int atomicNumber = Integer.parseInt(line.substring(7, 10).trim());
            IAtom atom = container.getBuilder().newInstance(IAtom.class, new Object[0]);
            atom.setAtomicNumber(atomicNumber);
            atom.setSymbol(PeriodicTable.getSymbol(atomicNumber));
            container.addAtom(atom);
        }
    }

    private void processBondsBlock(int lineCount, IAtomContainer container) throws IOException {
        for (int i = 0; i < lineCount; ++i) {
            String line = this.input.readLine();
            int atom1 = Integer.parseInt(line.substring(10, 13).trim()) - 1;
            int atom2 = Integer.parseInt(line.substring(16, 19).trim()) - 1;
            if (container.getBond(container.getAtom(atom1), container.getAtom(atom2)) != null) continue;
            IBond bond = container.getBuilder().newInstance(IBond.class, container.getAtom(atom1), container.getAtom(atom2));
            int order = Integer.parseInt(line.substring(23).trim());
            bond.setOrder(BondManipulator.createBondOrder(order));
            container.addBond(bond);
        }
    }

    private int getContentLinesCount(String line) {
        return Integer.parseInt(line.substring(18, 21).trim());
    }

    private String getCommand(String line) {
        return line.substring(2, 10).trim();
    }

    private boolean isCommand(String line) {
        return line.length() > 1 && line.charAt(0) == ' ' && line.charAt(1) == '/';
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }
}

