/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.atomtype.mapper;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.atomtypes.OWLAtomTypeMappingReader;

@TestClass(value="org.openscience.cdk.atomtype.mapper.AtomTypeMapperTest")
public class AtomTypeMapper {
    private static Map<String, AtomTypeMapper> mappers = new HashMap<String, AtomTypeMapper>();
    private String mappingFile;
    private Map<String, String> mappings;

    private AtomTypeMapper(String mappingFile) {
        this.mappingFile = mappingFile;
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(mappingFile);
        OWLAtomTypeMappingReader reader = new OWLAtomTypeMappingReader(new InputStreamReader(stream));
        this.mappings = reader.readAtomTypeMappings();
    }

    private AtomTypeMapper(String mappingFile, InputStream stream) {
        this.mappingFile = mappingFile;
        OWLAtomTypeMappingReader reader = new OWLAtomTypeMappingReader(new InputStreamReader(stream));
        this.mappings = reader.readAtomTypeMappings();
    }

    @TestMethod(value="testGetInstance_String")
    public static AtomTypeMapper getInstance(String mappingFile) {
        if (!mappers.containsKey(mappingFile)) {
            mappers.put(mappingFile, new AtomTypeMapper(mappingFile));
        }
        return mappers.get(mappingFile);
    }

    @TestMethod(value="testGetInstance_String_InputStream")
    public static AtomTypeMapper getInstance(String mappingFile, InputStream stream) {
        if (!mappers.containsKey(mappingFile)) {
            mappers.put(mappingFile, new AtomTypeMapper(mappingFile, stream));
        }
        return mappers.get(mappingFile);
    }

    @TestMethod(value="testMapAtomType_String")
    public String mapAtomType(String type) {
        return this.mappings.get(type);
    }

    @TestMethod(value="testGetMapping")
    public String getMapping() {
        return this.mappingFile;
    }
}

