/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.renderer.generators.BasicBondGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.HighlightAtomGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;

public class HighlightBondGenerator
extends BasicBondGenerator
implements IGenerator<IAtomContainer> {
    private HighlightBondDistance highlightBondDistance = new HighlightBondDistance();
    private HighlightBondShapeFilled highlightBondShapeFilled = new HighlightBondShapeFilled();

    private boolean shouldHighlight(IBond bond, RendererModel model) {
        return !super.bindsHydrogen(bond) || (Boolean)model.getParameter(BasicAtomGenerator.ShowExplicitHydrogens.class).getValue() != false;
    }

    @Override
    public IRenderingElement generate(IAtomContainer ac, RendererModel model) {
        IBond bond = model.getHighlightedBond();
        if (bond != null && this.shouldHighlight(bond, model)) {
            this.ringSet = super.getRingSet(ac);
            double r = (Double)model.getParameter(HighlightBondDistance.class).getValue() / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
            Color hColor = (Color)model.getParameter(HighlightAtomGenerator.HoverOverColor.class).getValue();
            Point2d p = bond.get2DCenter();
            boolean filled = (Boolean)model.getParameter(HighlightBondShapeFilled.class).getValue();
            return new OvalElement(p.x, p.y, r, filled, hColor);
        }
        return new ElementGroup();
    }

    @Override
    public List<IGeneratorParameter<?>> getParameters() {
        ArrayList parameters = new ArrayList();
        parameters.add(this.highlightBondDistance);
        parameters.add(this.highlightBondShapeFilled);
        parameters.addAll(super.getParameters());
        return parameters;
    }

    public static class HighlightBondShapeFilled
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.FALSE;
        }
    }

    public static class HighlightBondDistance
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 8.0;
        }
    }
}

