/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.base;

import nu.xom.Attribute;
import nu.xom.Node;
import org.xmlcml.cml.base.CMLAttribute;
import org.xmlcml.euclid.Util;

public class StringArraySTAttribute
extends CMLAttribute {
    public static final String JAVA_TYPE = "String[]";
    public static final String JAVA_GET_METHOD = "getStringArray";
    public static final String JAVA_SHORT_CLASS = "StringArraySTAttribute";
    protected String[] ss = null;
    protected int length = -1;

    public StringArraySTAttribute(String name) {
        super(name);
    }

    public StringArraySTAttribute(Attribute att) {
        this(att.getLocalName());
        this.setCMLValue(att.getValue());
    }

    public StringArraySTAttribute(StringArraySTAttribute att) {
        super(att);
        if (att.ss != null) {
            this.ss = new String[att.ss.length];
            for (int i = 0; i < this.ss.length; ++i) {
                this.ss[i] = att.ss[i];
            }
        }
        this.length = att.length;
    }

    public Node copy() {
        return new StringArraySTAttribute(this);
    }

    public StringArraySTAttribute(Attribute att, String value) {
        super(att, value.trim().replace("\\s+", " "));
    }

    public void setCMLValue(String s) {
        String[] split = s.trim().split("\\s+");
        this.setCMLValue(split);
    }

    public void setCMLValue(String[] ss) {
        this.checkValue(ss);
        this.ss = ss;
        this.setValue(Util.concatenate(ss, " "));
    }

    public void checkValue(String[] ss) {
        if (this.cmlType != null) {
            this.cmlType.checkValue(ss);
        }
    }

    public Object getCMLValue() {
        return this.ss;
    }

    public String[] getStringArray() {
        return this.ss;
    }

    public String getJavaType() {
        return JAVA_TYPE;
    }

    public String getJavaGetMethod() {
        return JAVA_GET_METHOD;
    }

    public String getJavaShortClassName() {
        return JAVA_SHORT_CLASS;
    }
}

