/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.LineElement;
import org.openscience.cdk.renderer.elements.WedgeLineElement;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;
import org.openscience.cdk.ringsearch.SSSRFinder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerComparatorBy2DCenter;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class BasicBondGenerator
implements IGenerator<IAtomContainer> {
    private IGeneratorParameter<Double> bondWidth = new BondWidth();
    private IGeneratorParameter<Double> bondDistance = new BondDistance();
    private IGeneratorParameter<Color> defaultBondColor = new DefaultBondColor();
    private IGeneratorParameter<Double> bondLength = new BondLength();
    private IGeneratorParameter<Double> wedgeWidth = new WedgeWidth();
    private IGeneratorParameter<Double> ringCenterProportion = new TowardsRingCenterProportion();
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(BasicBondGenerator.class);
    protected IRingSet ringSet;
    private Color overrideColor = null;
    private double overrideBondWidth = -1.0;

    public void setOverrideColor(Color color) {
        this.overrideColor = color;
    }

    public void setOverrideBondWidth(double bondWidth) {
        this.overrideBondWidth = bondWidth;
    }

    protected IRingSet getRingSet(IAtomContainer atomContainer) {
        IRingSet ringSet = (IRingSet)atomContainer.getBuilder().newInstance(IRingSet.class, new Object[0]);
        try {
            IMoleculeSet molecules = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)atomContainer);
            for (IAtomContainer mol : molecules.molecules()) {
                SSSRFinder sssrf = new SSSRFinder(mol);
                ringSet.add(sssrf.findSSSR());
            }
            return ringSet;
        }
        catch (Exception exception) {
            this.logger.warn((Object)("Could not partition molecule: " + exception.getMessage()));
            this.logger.debug((Object)exception);
            return ringSet;
        }
    }

    public Color getColorForBond(IBond bond, RendererModel model) {
        if (this.overrideColor != null) {
            return this.overrideColor;
        }
        Color color = (Color)((Map)model.getParameter(RendererModel.ColorHash.class).getValue()).get(bond);
        if (color == null) {
            return (Color)model.getParameter(DefaultBondColor.class).getValue();
        }
        return color;
    }

    public double getWidthForBond(IBond bond, RendererModel model) {
        double scale = (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        if (this.overrideBondWidth != -1.0) {
            return this.overrideBondWidth / scale;
        }
        return (Double)model.getParameter(BondWidth.class).getValue() / scale;
    }

    @Override
    public IRenderingElement generate(IAtomContainer ac, RendererModel model) {
        ElementGroup group = new ElementGroup();
        this.ringSet = this.getRingSet(ac);
        this.ringSet.sortAtomContainers((Comparator)new AtomContainerComparatorBy2DCenter());
        for (IBond bond : ac.bonds()) {
            group.add(this.generate(bond, model));
        }
        return group;
    }

    @Override
    public IRenderingElement generate(IBond currentBond, RendererModel model) {
        IRing ring = RingSetManipulator.getHeaviestRing((IRingSet)this.ringSet, (IBond)currentBond);
        if (ring != null) {
            return this.generateRingElements(currentBond, ring, model);
        }
        return this.generateBond(currentBond, model);
    }

    public IRenderingElement generateBondElement(IBond bond, RendererModel model) {
        return this.generateBondElement(bond, bond.getOrder(), model);
    }

    public IRenderingElement generateBondElement(IBond bond, IBond.Order type, RendererModel model) {
        if (bond.getAtomCount() > 2) {
            return null;
        }
        Point2d p1 = bond.getAtom(0).getPoint2d();
        Point2d p2 = bond.getAtom(1).getPoint2d();
        Color color = this.getColorForBond(bond, model);
        double bondWidth = this.getWidthForBond(bond, model);
        double bondDistance = this.bondDistance.getValue() / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        if (type == IBond.Order.SINGLE) {
            return new LineElement(p1.x, p1.y, p2.x, p2.y, bondWidth, color);
        }
        ElementGroup group = new ElementGroup();
        switch (type) {
            case DOUBLE: {
                this.createLines(p1, p2, bondWidth, bondDistance, color, group);
                break;
            }
            case TRIPLE: {
                this.createLines(p1, p2, bondWidth, bondDistance * 2.0, color, group);
                group.add(new LineElement(p1.x, p1.y, p2.x, p2.y, bondWidth, color));
                break;
            }
            case QUADRUPLE: {
                this.createLines(p1, p2, bondWidth, bondDistance, color, group);
                this.createLines(p1, p2, bondWidth, bondDistance * 4.0, color, group);
            }
        }
        return group;
    }

    private void createLines(Point2d p1, Point2d p2, double width, double dist, Color c, ElementGroup group) {
        double[] out = this.generateDistanceData(p1, p2, dist);
        LineElement l1 = new LineElement(out[0], out[1], out[4], out[5], width, c);
        LineElement l2 = new LineElement(out[2], out[3], out[6], out[7], width, c);
        group.add(l1);
        group.add(l2);
    }

    private double[] generateDistanceData(Point2d p1, Point2d p2, double dist) {
        Vector2d normal = new Vector2d();
        normal.sub(p2, p1);
        normal = new Vector2d(-normal.y, normal.x);
        normal.normalize();
        normal.scale(dist);
        Point2d line1p1 = new Point2d();
        Point2d line1p2 = new Point2d();
        line1p1.add(p1, normal);
        line1p2.add(p2, normal);
        normal.negate();
        Point2d line2p1 = new Point2d();
        Point2d line2p2 = new Point2d();
        line2p1.add(p1, normal);
        line2p2.add(p2, normal);
        return new double[]{line1p1.x, line1p1.y, line2p1.x, line2p1.y, line1p2.x, line1p2.y, line2p2.x, line2p2.y};
    }

    public IRenderingElement generateRingElements(IBond bond, IRing ring, RendererModel model) {
        if (this.isSingle(bond) && this.isStereoBond(bond)) {
            return this.generateStereoElement(bond, model);
        }
        if (this.isDouble(bond)) {
            ElementGroup pair = new ElementGroup();
            IRenderingElement e1 = this.generateBondElement(bond, IBond.Order.SINGLE, model);
            LineElement e2 = this.generateInnerElement(bond, ring, model);
            pair.add(e1);
            pair.add(e2);
            return pair;
        }
        return this.generateBondElement(bond, model);
    }

    public LineElement generateInnerElement(IBond bond, IRing ring, RendererModel model) {
        Point2d center = GeometryTools.get2DCenter((IAtomContainer)ring);
        Point2d a = bond.getAtom(0).getPoint2d();
        Point2d b = bond.getAtom(1).getPoint2d();
        double DIST = (Double)model.getParameter(TowardsRingCenterProportion.class).getValue();
        Point2d w = new Point2d();
        w.interpolate(a, center, DIST);
        Point2d u = new Point2d();
        u.interpolate(b, center, DIST);
        double alpha = 0.2;
        Point2d ww = new Point2d();
        ww.interpolate(w, u, alpha);
        Point2d uu = new Point2d();
        uu.interpolate(u, w, alpha);
        return new LineElement(u.x, u.y, w.x, w.y, this.getWidthForBond(bond, model), this.getColorForBond(bond, model));
    }

    private IRenderingElement generateStereoElement(IBond bond, RendererModel model) {
        IBond.Stereo stereo = bond.getStereo();
        boolean dashed = false;
        WedgeLineElement.Direction dir = WedgeLineElement.Direction.toSecond;
        if (stereo == IBond.Stereo.DOWN || stereo == IBond.Stereo.DOWN_INVERTED) {
            dashed = true;
        }
        if (stereo == IBond.Stereo.DOWN_INVERTED || stereo == IBond.Stereo.UP_INVERTED) {
            dir = WedgeLineElement.Direction.toFirst;
        }
        IRenderingElement base = this.generateBondElement(bond, IBond.Order.SINGLE, model);
        return new WedgeLineElement((LineElement)base, dashed, dir, this.getColorForBond(bond, model));
    }

    public boolean isDouble(IBond bond) {
        return bond.getOrder() == IBond.Order.DOUBLE;
    }

    public boolean isSingle(IBond bond) {
        return bond.getOrder() == IBond.Order.SINGLE;
    }

    public boolean isStereoBond(IBond bond) {
        return bond.getStereo() != IBond.Stereo.NONE && bond.getStereo() != (IBond.Stereo)CDKConstants.UNSET && bond.getStereo() != IBond.Stereo.E_Z_BY_COORDINATES;
    }

    public boolean bindsHydrogen(IBond bond) {
        for (int i = 0; i < bond.getAtomCount(); ++i) {
            IAtom atom = bond.getAtom(i);
            if (!"H".equals(atom.getSymbol())) continue;
            return true;
        }
        return false;
    }

    public IRenderingElement generateBond(IBond bond, RendererModel model) {
        boolean showExplicitHydrogens = (Boolean)model.getParameter(BasicAtomGenerator.ShowExplicitHydrogens.class).getValue();
        if (!showExplicitHydrogens && this.bindsHydrogen(bond)) {
            return null;
        }
        if (this.isStereoBond(bond)) {
            return this.generateStereoElement(bond, model);
        }
        return this.generateBondElement(bond, model);
    }

    @Override
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(this.bondWidth, this.defaultBondColor, this.bondLength, this.wedgeWidth, this.bondDistance, this.ringCenterProportion);
    }

    public static class TowardsRingCenterProportion
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 0.15;
        }
    }

    public static class WedgeWidth
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 2.0;
        }
    }

    public static class BondLength
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 40.0;
        }
    }

    public static class DefaultBondColor
    extends AbstractGeneratorParameter<Color> {
        @Override
        public Color getDefault() {
            return Color.BLACK;
        }
    }

    public static class BondDistance
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 2.0;
        }
    }

    public static class BondWidth
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 1.0;
        }
    }
}

