/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.edit;

import java.util.List;
import java.util.Set;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.controller.Changed;
import org.openscience.cdk.controller.edit.AbstractEdit;
import org.openscience.cdk.controller.edit.IEdit;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.layout.AtomPlacer;

public class AppendAtom
extends AbstractEdit
implements IEdit {
    String symbol;
    IAtom source;
    Point2d pos;
    IAtom newSource;
    IAtom newAtom;
    IBond newBond;
    IBond.Stereo newStereo;

    public static AppendAtom appendAtom(String symbol, IAtom source) {
        return new AppendAtom(symbol, source, null, null);
    }

    public static AppendAtom appendAtom(String symbol, IAtom source, IBond.Stereo stereo) {
        return new AppendAtom(symbol, source, null, stereo);
    }

    public static AppendAtom appendAtom(String symbol, IAtom source, Point2d pos) {
        return new AppendAtom(symbol, source, pos, null);
    }

    public static AppendAtom addNewBond(Point2d pos) {
        return new AppendAtom("C", null, pos, null);
    }

    private AppendAtom(String symbol, IAtom source, Point2d pos, IBond.Stereo stereo) {
        this.symbol = symbol;
        this.source = source;
        this.pos = pos;
        this.newStereo = stereo;
    }

    private void init() {
        IAtom start;
        if (this.source == null) {
            this.newSource = start = (IAtom)this.model.getBuilder().newInstance(IAtom.class, new Object[]{this.symbol, this.pos});
        } else {
            start = this.source;
        }
        this.newAtom = this.pos != null && this.source != null ? (IAtom)this.model.getBuilder().newInstance(IAtom.class, new Object[]{this.symbol, this.pos}) : (IAtom)this.model.getBuilder().newInstance(IAtom.class, new Object[]{this.symbol});
        this.newBond = this.newStereo != null ? (IBond)this.model.getBuilder().newInstance(IBond.class, new Object[]{start, this.newAtom, IBond.Order.SINGLE, this.newStereo}) : (IBond)this.model.getBuilder().newInstance(IBond.class, new Object[]{start, this.newAtom});
        if (this.pos == null) {
            double bondLength = this.model.getBondCount() >= 1 ? GeometryTools.getBondLengthAverage((IAtomContainer)this.model) : 1.4;
            AppendAtom.placeNewAtom(this.model, start, this.newAtom, bondLength);
        }
    }

    @Override
    public void redo() {
        if (this.newAtom == null && this.newBond == null) {
            this.init();
        }
        if (this.newSource != null) {
            this.model.addAtom(this.newSource);
        }
        this.model.addAtom(this.newAtom);
        this.model.addBond(this.newBond);
        this.updateHydrogenCount(this.newSource != null ? this.newSource : this.source, this.newAtom);
    }

    static void placeNewAtom(IAtomContainer model, IAtom sourceAtom, IAtom atomToPlace, double bondLength) {
        AtomPlacer atomPlacer = new AtomPlacer();
        atomPlacer.setMolecule(model);
        List connectedAtoms = model.getConnectedAtomsList(sourceAtom);
        if (connectedAtoms.size() == 0) {
            Point2d newAtomPoint = new Point2d(sourceAtom.getPoint2d());
            double angle = Math.toRadians(-30.0);
            Vector2d vec1 = new Vector2d(Math.cos(angle), Math.sin(angle));
            vec1.scale(bondLength);
            newAtomPoint.add(vec1);
            atomToPlace.setPoint2d(newAtomPoint);
        } else if (connectedAtoms.size() == 1) {
            IMolecule ac = (IMolecule)model.getBuilder().newInstance(IMolecule.class, new Object[0]);
            ac.addAtom(sourceAtom);
            ac.addAtom(atomToPlace);
            Point2d distanceMeasure = new Point2d(0.0, 0.0);
            IAtom connectedAtom = (IAtom)connectedAtoms.get(0);
            Vector2d v = atomPlacer.getNextBondVector(sourceAtom, connectedAtom, distanceMeasure, true);
            atomPlacer.placeLinearChain((IAtomContainer)ac, v, bondLength);
        } else {
            IMolecule placedAtoms = (IMolecule)model.getBuilder().newInstance(IMolecule.class, new Object[0]);
            for (IAtom conAtom : connectedAtoms) {
                placedAtoms.addAtom(conAtom);
            }
            Point2d center2D = GeometryTools.get2DCenter((IAtomContainer)placedAtoms);
            IAtomContainer unplacedAtoms = (IAtomContainer)model.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            unplacedAtoms.addAtom(atomToPlace);
            atomPlacer.distributePartners(sourceAtom, (IAtomContainer)placedAtoms, center2D, unplacedAtoms, bondLength);
        }
    }

    @Override
    public void undo() {
        this.model.removeBond(this.newBond);
        this.model.removeAtom(this.newAtom);
        if (this.newSource != null) {
            this.model.removeAtom(this.newSource);
        } else {
            this.updateHydrogenCount(this.source);
        }
    }

    @Override
    public Set<Changed> getTypeOfChanges() {
        return AppendAtom.changed(Changed.Structure);
    }
}

