/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    ToolItem lastFocus;
    ImageList imageList;

    public ToolBar(Composite composite, int n) {
        super(composite, ToolBar.checkStyle(n));
        this.style = (n & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
        int n2 = (n & 0x200) != 0 ? 1 : 0;
        OS.gtk_toolbar_set_orientation(this.handle, n2);
    }

    static int checkStyle(int n) {
        if ((n & 0x40) != 0) {
            n &= 0xFFFFFFBF;
        }
        return n & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createHandle(int n) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        this.handle = OS.gtk_toolbar_new();
        if (this.handle == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        if ((this.style & 0x800000) != 0) {
            byte[] byArray = Converter.wcsToMbcs(null, "swt-toolbar-flat", true);
            OS.gtk_widget_set_name(this.handle, byArray);
        }
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        return this.computeNativeSize(this.handle, n, n2, bl);
    }

    @Override
    long eventHandle() {
        return this.fixedHandle;
    }

    @Override
    long enterExitHandle() {
        return this.handle;
    }

    @Override
    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        super.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        ToolItem[] toolItemArray = this.getItems();
        if (this.toolTipText == null) {
            for (int i = 0; i < toolItemArray.length; ++i) {
                ToolItem toolItem = toolItemArray[i];
                if (toolItem.toolTipText == null) continue;
                toolItem.setToolTipText(shell2, null);
                toolItem.setToolTipText(shell, toolItem.toolTipText);
            }
        }
    }

    @Override
    boolean forceFocus(long l) {
        if (this.lastFocus != null && this.lastFocus.setFocus()) {
            return true;
        }
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            ToolItem toolItem = toolItemArray[i];
            if (!toolItem.setFocus()) continue;
            return true;
        }
        return super.forceFocus(l);
    }

    public ToolItem getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= this.getItemCount()) {
            this.error(6);
        }
        return this.getItems()[n];
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            if (!toolItemArray[i].getBounds().contains(point)) continue;
            return toolItemArray[i];
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        long l = OS.gtk_container_get_children(this.handle);
        if (l == 0L) {
            return 0;
        }
        int n = OS.g_list_length(l);
        OS.g_list_free(l);
        return n;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        long l = OS.gtk_container_get_children(this.handle);
        if (l == 0L) {
            return new ToolItem[0];
        }
        int n = OS.g_list_length(l);
        ToolItem[] toolItemArray = new ToolItem[n];
        for (int i = 0; i < n; ++i) {
            long l2 = OS.g_list_nth_data(l, i);
            Widget widget = this.display.getWidget(l2);
            toolItemArray[i] = (ToolItem)widget;
        }
        OS.g_list_free(l);
        return toolItemArray;
    }

    public int getRowCount() {
        this.checkWidget();
        return 1;
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        int n;
        int n2;
        if (!this.hasFocus()) {
            return 0L;
        }
        long l3 = super.gtk_key_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        ToolItem[] toolItemArray = this.getItems();
        int n3 = toolItemArray.length;
        for (n2 = 0; n2 < n3 && !toolItemArray[n2].hasFocus(); ++n2) {
        }
        GdkEventKey gdkEventKey = new GdkEventKey();
        OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
        boolean bl = false;
        switch (gdkEventKey.keyval) {
            case 65361: 
            case 65362: {
                bl = false;
                break;
            }
            case 65364: {
                if (0 <= n2 && n2 < n3) {
                    ToolItem toolItem = toolItemArray[n2];
                    if ((toolItem.style & 4) != 0) {
                        Event event = new Event();
                        event.detail = 4;
                        long l4 = toolItem.topHandle();
                        event.x = OS.GTK_WIDGET_X(l4);
                        event.y = OS.GTK_WIDGET_Y(l4) + OS.GTK_WIDGET_HEIGHT(l4);
                        if ((this.style & 0x8000000) != 0) {
                            event.x = this.getClientWidth() - OS.GTK_WIDGET_WIDTH(l4) - event.x;
                        }
                        toolItem.postEvent(13, event);
                        return l3;
                    }
                }
            }
            case 65363: {
                bl = true;
                break;
            }
            default: {
                return l3;
            }
        }
        if ((this.style & 0x8000000) != 0) {
            bl = !bl;
        }
        int n4 = n2;
        int n5 = n = bl ? 1 : -1;
        while ((n2 = (n2 + n + n3) % n3) != n4) {
            ToolItem toolItem = toolItemArray[n2];
            if (!toolItem.setFocus()) continue;
            return l3;
        }
        return l3;
    }

    @Override
    boolean hasFocus() {
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            ToolItem toolItem = toolItemArray[i];
            if (!toolItem.hasFocus()) continue;
            return true;
        }
        return super.hasFocus();
    }

    public int indexOf(ToolItem toolItem) {
        this.checkWidget();
        if (toolItem == null) {
            this.error(4);
        }
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            if (toolItem != toolItemArray[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    boolean mnemonicHit(char c) {
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            long l = toolItemArray[i].labelHandle;
            if (l == 0L || !this.mnemonicHit(l, c)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char c) {
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            long l = toolItemArray[i].labelHandle;
            if (l == 0L || !this.mnemonicMatch(l, c)) continue;
            return true;
        }
        return false;
    }

    void relayout() {
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            ToolItem toolItem = toolItemArray[i];
            if (toolItem == null) continue;
            toolItem.resizeControl();
        }
    }

    @Override
    void releaseChildren(boolean bl) {
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            ToolItem toolItem = toolItemArray[i];
            if (toolItem == null || toolItem.isDisposed()) continue;
            toolItem.release(false);
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            ToolItem toolItem = toolItemArray[i];
            if (toolItem.control != control) continue;
            toolItem.setControl(null);
        }
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if ((n5 & 0x100) != 0) {
            this.relayout();
        }
        return n5;
    }

    @Override
    void setFontDescription(long l) {
        super.setFontDescription(l);
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            toolItemArray[i].setFontDescription(l);
        }
        this.relayout();
    }

    @Override
    void setForegroundColor(GdkColor gdkColor) {
        super.setForegroundColor(gdkColor);
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            toolItemArray[i].setForegroundColor(gdkColor);
        }
    }

    @Override
    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        Shell shell = this._getShell();
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            String string2 = string != null ? null : toolItemArray[i].toolTipText;
            shell.setToolTipText(toolItemArray[i].handle, string2);
        }
    }
}

