/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.modeling.builder3d;

import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.modeling.builder3d.AtomTetrahedralLigandPlacer3D;

public class AtomPlacer3D {
    private Map<Object, List> pSet = null;
    private double[] distances;
    private int[] first_atoms = null;
    private double[] angles = null;
    private int[] second_atoms = null;
    private double[] dihedrals = null;
    private int[] third_atoms = null;
    private static final double DIHEDRAL_EXTENDED_CHAIN = Math.PI;
    private static final double DIHEDRAL_BRANCHED_CHAIN = 0.0;
    private static final double DEFAULT_BOND_LENGTH = 1.5;
    private static final double DEFAULT_SP3_ANGLE = 109.471;
    private static final double DEFAULT_SP2_ANGLE = 120.0;
    private static final double DEFAULT_SP_ANGLE = 180.0;

    AtomPlacer3D() {
    }

    public void initilize(Map parameterSet) {
        this.pSet = parameterSet;
    }

    public int[] findHeavyAtomsInChain(IAtomContainer molecule, IAtomContainer chain) {
        int[] heavy = new int[]{-1, -1};
        int hc = 0;
        for (int i = 0; i < chain.getAtomCount(); ++i) {
            if (chain.getAtom(i).getSymbol().equals("H")) continue;
            if (heavy[0] < 0) {
                heavy[0] = molecule.getAtomNumber(chain.getAtom(i));
            }
            ++hc;
        }
        heavy[1] = hc;
        return heavy;
    }

    public IAtomContainer markPlaced(IAtomContainer ac) {
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            ac.getAtom(i).setFlag(0, true);
        }
        return ac;
    }

    public void placeAliphaticHeavyChain(IAtomContainer molecule, IAtomContainer chain) throws CDKException {
        int[] first = new int[2];
        int counter = 1;
        int nextAtomNr = 0;
        String ID1 = "";
        String ID2 = "";
        String ID3 = "";
        first = this.findHeavyAtomsInChain(molecule, chain);
        this.distances = new double[first[1]];
        this.first_atoms = new int[first[1]];
        this.angles = new double[first[1]];
        this.second_atoms = new int[first[1]];
        this.dihedrals = new double[first[1]];
        this.third_atoms = new int[first[1]];
        this.first_atoms[0] = first[0];
        molecule.getAtom(this.first_atoms[0]).setFlag(4, true);
        int hybridisation = 0;
        for (int i = 0; i < chain.getAtomCount(); ++i) {
            block14: {
                if (!(!chain.getAtom(i).getSymbol().equals("H") & !chain.getAtom(i).getFlag(4))) continue;
                nextAtomNr = molecule.getAtomNumber(chain.getAtom(i));
                ID2 = molecule.getAtom(this.first_atoms[counter - 1]).getAtomTypeName();
                ID1 = molecule.getAtom(nextAtomNr).getAtomTypeName();
                this.distances[counter] = this.getBondLengthValue(ID1, ID2);
                this.first_atoms[counter] = nextAtomNr;
                this.second_atoms[counter] = this.first_atoms[counter - 1];
                if (counter > 1) {
                    ID3 = molecule.getAtom(this.first_atoms[counter - 2]).getAtomTypeName();
                    hybridisation = this.getHybridisationState(molecule.getAtom(this.first_atoms[counter - 1]));
                    this.angles[counter] = this.getAngleValue(ID1, ID2, ID3);
                    if (this.angles[counter] == -1.0) {
                        if (hybridisation == 3) {
                            this.angles[counter] = 109.471;
                        } else if (hybridisation == 2) {
                            this.angles[counter] = 120.0;
                        } else if (hybridisation == 1) {
                            this.angles[counter] = 180.0;
                        }
                    }
                    this.third_atoms[counter] = this.first_atoms[counter - 2];
                } else {
                    this.angles[counter] = -1.0;
                    this.third_atoms[counter] = -1;
                }
                if (counter > 2) {
                    try {
                        if (this.getDoubleBondConfiguration2D(molecule.getBond(molecule.getAtom(this.first_atoms[counter - 1]), molecule.getAtom(this.first_atoms[counter - 2])), molecule.getAtom(this.first_atoms[counter]).getPoint2d(), molecule.getAtom(this.first_atoms[counter - 1]).getPoint2d(), molecule.getAtom(this.first_atoms[counter - 2]).getPoint2d(), molecule.getAtom(this.first_atoms[counter - 3]).getPoint2d()) == 5) {
                            this.dihedrals[counter] = 0.0;
                            break block14;
                        }
                        this.dihedrals[counter] = Math.PI;
                    }
                    catch (CDKException ex1) {
                        this.dihedrals[counter] = Math.PI;
                    }
                } else {
                    this.dihedrals[counter] = -1.0;
                }
            }
            ++counter;
        }
    }

    public void zmatrixChainToCartesian(IAtomContainer molecule, boolean flag_branched) {
        Point3d result = null;
        for (int index = 0; index < this.distances.length; ++index) {
            if (index == 0) {
                result = new Point3d(0.0, 0.0, 0.0);
            } else if (index == 1) {
                result = new Point3d(this.distances[1], 0.0, 0.0);
            } else if (index == 2) {
                result = new Point3d(-Math.cos(this.angles[2] / 180.0 * Math.PI) * this.distances[2] + this.distances[1], Math.sin(this.angles[2] / 180.0 * Math.PI) * this.distances[2], 0.0);
            } else {
                Vector3d cd = new Vector3d();
                cd.sub(molecule.getAtom(this.third_atoms[index]).getPoint3d(), molecule.getAtom(this.second_atoms[index]).getPoint3d());
                Vector3d bc = new Vector3d();
                bc.sub(molecule.getAtom(this.second_atoms[index]).getPoint3d(), molecule.getAtom(this.first_atoms[index - 3]).getPoint3d());
                Vector3d n1 = new Vector3d();
                n1.cross(cd, bc);
                n1.normalize();
                Vector3d n2 = null;
                n2 = index == 3 & flag_branched ? AtomTetrahedralLigandPlacer3D.rotate(n1, bc, 0.0) : AtomTetrahedralLigandPlacer3D.rotate(n1, bc, this.dihedrals[index]);
                n2.normalize();
                Vector3d ba = new Vector3d();
                if (index == 3 & flag_branched) {
                    ba = AtomTetrahedralLigandPlacer3D.rotate(cd, n2, -this.angles[index] / 180.0 * Math.PI);
                    ba = AtomTetrahedralLigandPlacer3D.rotate(ba, cd, -this.angles[index] / 180.0 * Math.PI);
                } else {
                    ba = AtomTetrahedralLigandPlacer3D.rotate(cd, n2, -this.angles[index] / 180.0 * Math.PI);
                }
                ba.normalize();
                Vector3d ban = new Vector3d(ba);
                ban.scale(this.distances[index]);
                result = new Point3d();
                result.add(molecule.getAtom(this.first_atoms[index - 1]).getPoint3d(), ban);
            }
            if (molecule.getAtom(this.first_atoms[index]).getPoint3d() != null && molecule.getAtom(this.first_atoms[index]).getFlag(0) || molecule.getAtom(this.first_atoms[index]).getFlag(1) || molecule.getAtom(this.first_atoms[index]).getSymbol().equals("H")) continue;
            molecule.getAtom(this.first_atoms[index]).setPoint3d(result);
            molecule.getAtom(this.first_atoms[index]).setFlag(0, true);
        }
    }

    private int getHybridisationState(IAtom atom1) {
        IBond.Order maxBondOrder = atom1.getMaxBondOrder();
        if (atom1.getFormalNeighbourCount() != 1) {
            if (atom1.getFormalNeighbourCount() == 2 || maxBondOrder == IBond.Order.TRIPLE) {
                return 1;
            }
            if (atom1.getFormalNeighbourCount() == 3 || maxBondOrder == IBond.Order.DOUBLE) {
                return 2;
            }
            return 3;
        }
        return -1;
    }

    private int getDoubleBondConfiguration2D(IBond bond, Point2d a, Point2d b, Point2d c, Point2d d) throws CDKException {
        if (bond.getOrder() != IBond.Order.DOUBLE) {
            return 0;
        }
        Point2d cb = new Point2d(c.x - b.x, c.y - b.y);
        Point2d xT = new Point2d(cb.x - 1.0, cb.y);
        a.y = a.y - b.y - xT.y;
        d.y = d.y - b.y - xT.y;
        if (a.y > 0.0 && d.y > 0.0 || a.y < 0.0 && d.y < 0.0) {
            return 5;
        }
        return 6;
    }

    public double getBondLengthValue(String id1, String id2) {
        String dkey = "";
        if (this.pSet.containsKey("bond" + id1 + ";" + id2)) {
            dkey = "bond" + id1 + ";" + id2;
        } else if (this.pSet.containsKey("bond" + id2 + ";" + id1)) {
            dkey = "bond" + id2 + ";" + id1;
        } else {
            System.out.println("KEYError:Unknown distance key in pSet: " + id2 + " ;" + id1 + " take default bon length:" + 1.5);
            return 1.5;
        }
        return (Double)this.pSet.get(dkey).get(0);
    }

    public double getAngleValue(String id1, String id2, String id3) {
        String akey = "";
        if (this.pSet.containsKey("angle" + id1 + ";" + id2 + ";" + id3)) {
            akey = "angle" + id1 + ";" + id2 + ";" + id3;
        } else if (this.pSet.containsKey("angle" + id3 + ";" + id2 + ";" + id1)) {
            akey = "angle" + id3 + ";" + id2 + ";" + id1;
        } else if (this.pSet.containsKey("angle" + id2 + ";" + id1 + ";" + id3)) {
            akey = "angle" + id2 + ";" + id1 + ";" + id3;
        } else if (this.pSet.containsKey("angle" + id1 + ";" + id3 + ";" + id2)) {
            akey = "angle" + id1 + ";" + id3 + ";" + id2;
        } else if (this.pSet.containsKey("angle" + id3 + ";" + id1 + ";" + id2)) {
            akey = "angle" + id3 + ";" + id1 + ";" + id2;
        } else if (this.pSet.containsKey("angle" + id2 + ";" + id3 + ";" + id1)) {
            akey = "angle" + id2 + ";" + id3 + ";" + id1;
        } else {
            return -1.0;
        }
        return (Double)this.pSet.get(akey).get(0);
    }

    public IAtom getNextUnplacedHeavyAtomWithAliphaticPlacedNeighbour(IAtomContainer molecule) {
        for (IBond bond : molecule.bonds()) {
            if (bond.getAtom(0).getFlag(0) & !bond.getAtom(1).getFlag(0) && bond.getAtom(1).getFlag(3) & !bond.getAtom(1).getSymbol().equals("H")) {
                return bond.getAtom(1);
            }
            if (!(bond.getAtom(1).getFlag(0) & !bond.getAtom(0).getFlag(0)) || !(bond.getAtom(0).getFlag(3) & !bond.getAtom(0).getSymbol().equals("H"))) continue;
            return bond.getAtom(0);
        }
        return null;
    }

    public IAtom getNextPlacedHeavyAtomWithUnplacedAliphaticNeighbour(IAtomContainer molecule) {
        for (IBond bond : molecule.bonds()) {
            IAtom atom0 = bond.getAtom(0);
            IAtom atom1 = bond.getAtom(1);
            if (atom0.getFlag(0) & !atom1.getFlag(0) && atom1.getFlag(3) & !atom0.getSymbol().equals("H") & !atom1.getSymbol().equals("H")) {
                return atom0;
            }
            if (!(atom1.getFlag(0) & !atom0.getFlag(0)) || !(atom0.getFlag(3) & !atom1.getSymbol().equals("H") & !atom0.getSymbol().equals("H"))) continue;
            return atom1;
        }
        return null;
    }

    public IAtom getNextPlacedHeavyAtomWithUnplacedRingNeighbour(IAtomContainer molecule) {
        for (IBond bond : molecule.bonds()) {
            IAtom atom0 = bond.getAtom(0);
            IAtom atom1 = bond.getAtom(1);
            if (atom0.getFlag(0) & !atom1.getFlag(0) && atom1.getFlag(1) & !atom0.getSymbol().equals("H") & !atom1.getSymbol().equals("H")) {
                return atom0;
            }
            if (!(atom1.getFlag(0) & !atom0.getFlag(0)) || !(atom0.getFlag(1) & !atom1.getSymbol().equals("H") & !atom0.getSymbol().equals("H"))) continue;
            return atom1;
        }
        return null;
    }

    public IAtom getFarthestAtom(Point3d refAtomPoint, IAtomContainer ac) {
        double distance = 0.0;
        IAtom atom = null;
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            if (ac.getAtom(i).getPoint3d() == null || !(Math.abs(refAtomPoint.distance(ac.getAtom(i).getPoint3d())) > distance)) continue;
            atom = ac.getAtom(i);
            distance = Math.abs(refAtomPoint.distance(ac.getAtom(i).getPoint3d()));
        }
        return atom;
    }

    public IAtom getUnplacedRingHeavyAtom(IAtomContainer molecule, IAtom atom) {
        List<IBond> bonds = molecule.getConnectedBondsList(atom);
        IAtom connectedAtom = null;
        for (int i = 0; i < bonds.size(); ++i) {
            connectedAtom = bonds.get(i).getConnectedAtom(atom);
            if (connectedAtom.getFlag(0) || connectedAtom.getSymbol().equals("H") || !connectedAtom.getFlag(1)) continue;
            return connectedAtom;
        }
        return connectedAtom;
    }

    public Point3d geometricCenterAllPlacedAtoms(IAtomContainer molecule) {
        IAtomContainer allPlacedAtoms = this.getAllPlacedAtoms(molecule);
        return GeometryTools.get3DCenter(allPlacedAtoms);
    }

    public IAtom getPlacedHeavyAtom(IAtomContainer molecule, IAtom atom) {
        List<IBond> bonds = molecule.getConnectedBondsList(atom);
        for (int i = 0; i < bonds.size(); ++i) {
            IAtom connectedAtom = bonds.get(i).getConnectedAtom(atom);
            if (!(connectedAtom.getFlag(0) & !connectedAtom.getSymbol().equals("H"))) continue;
            return connectedAtom;
        }
        return null;
    }

    public IAtom getPlacedHeavyAtom(IAtomContainer molecule, IAtom atomA, IAtom atomB) {
        List<IBond> bonds = molecule.getConnectedBondsList(atomA);
        for (int i = 0; i < bonds.size(); ++i) {
            IAtom connectedAtom = bonds.get(i).getConnectedAtom(atomA);
            if (!connectedAtom.getFlag(0) || connectedAtom.getSymbol().equals("H") || connectedAtom == atomB) continue;
            return connectedAtom;
        }
        return null;
    }

    public IAtomContainer getPlacedHeavyAtoms(IAtomContainer molecule, IAtom atom) {
        List<IBond> bonds = molecule.getConnectedBondsList(atom);
        IAtomContainer connectedAtoms = molecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtom connectedAtom = null;
        for (int i = 0; i < bonds.size(); ++i) {
            connectedAtom = bonds.get(i).getConnectedAtom(atom);
            if (!(connectedAtom.getFlag(0) & !connectedAtom.getSymbol().equals("H"))) continue;
            connectedAtoms.addAtom(connectedAtom);
        }
        return connectedAtoms;
    }

    public int numberOfUnplacedHeavyAtoms(IAtomContainer ac) {
        int nUnplacedHeavyAtoms = 0;
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            if (ac.getAtom(i).getFlag(0) || ac.getAtom(i).equals("H")) continue;
            ++nUnplacedHeavyAtoms;
        }
        return nUnplacedHeavyAtoms;
    }

    private IAtomContainer getAllPlacedAtoms(IAtomContainer molecule) {
        AtomContainer placedAtoms = new AtomContainer();
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            if (!molecule.getAtom(i).getFlag(0)) continue;
            placedAtoms.addAtom(molecule.getAtom(i));
        }
        return placedAtoms;
    }

    public boolean allHeavyAtomsPlaced(IAtomContainer ac) {
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            if (!(!ac.getAtom(i).getFlag(0) & !ac.getAtom(i).getSymbol().equals("H"))) continue;
            return false;
        }
        return true;
    }
}

