/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.vecmath.Vector2d;
import org.openscience.cdk.controller.Changed;
import org.openscience.cdk.controller.edit.AbstractEdit;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;

public class Move
extends AbstractEdit {
    Collection<IAtom> atomsToMove;
    Vector2d amoutn;

    public static Move move(Vector2d amoutn, IAtom ... atoms) {
        return new Move(amoutn, Arrays.asList(atoms));
    }

    public static Move move(Vector2d amount, IBond ... bonds) {
        HashSet<IAtom> atoms = new HashSet<IAtom>();
        for (IBond bond : bonds) {
            for (IAtom atom : bond.atoms()) {
                atoms.add(atom);
            }
        }
        return new Move(amount, atoms);
    }

    public static Move move(Vector2d amount, Collection<IAtom> atoms) {
        return new Move(amount, atoms);
    }

    protected Move(Vector2d amount, Collection<IAtom> atomsToMove) {
        this.atomsToMove = new ArrayList<IAtom>(atomsToMove);
        this.amoutn = new Vector2d(amount);
    }

    @Override
    public Set<Changed> getTypeOfChanges() {
        return Move.changed(Changed.Coordinates);
    }

    @Override
    public void redo() {
        for (IAtom atom : this.atomsToMove) {
            atom.getPoint2d().add(this.amoutn);
        }
    }

    @Override
    public void undo() {
        for (IAtom atom : this.atomsToMove) {
            atom.getPoint2d().sub(this.amoutn);
        }
    }
}

