/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Scale
extends Control {
    public Scale(Composite composite, int n) {
        super(composite, Scale.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return Scale.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        if ((this.style & 0x100) != 0) {
            if (n == -1) {
                point.x = 2 * point.x;
            }
        } else if (n2 == -1) {
            point.y = 2 * point.y;
        }
        return point;
    }

    @Override
    void createHandle(int n) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        long l = OS.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 0.0);
        if (l == 0L) {
            this.error(2);
        }
        this.handle = (this.style & 0x100) != 0 ? OS.gtk_hscale_new(l) : OS.gtk_vscale_new(l);
        if (this.handle == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        OS.gtk_scale_set_digits(this.handle, 0);
        OS.gtk_scale_set_draw_value(this.handle, false);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.value_changed, this.display.closures[57], false);
    }

    public int getIncrement() {
        this.checkWidget();
        long l = OS.gtk_range_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        return (int)gtkAdjustment.step_increment;
    }

    public int getMaximum() {
        this.checkWidget();
        long l = OS.gtk_range_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        return (int)gtkAdjustment.upper;
    }

    public int getMinimum() {
        this.checkWidget();
        long l = OS.gtk_range_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        return (int)gtkAdjustment.lower;
    }

    public int getPageIncrement() {
        this.checkWidget();
        long l = OS.gtk_range_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        return (int)gtkAdjustment.page_increment;
    }

    public int getSelection() {
        this.checkWidget();
        long l = OS.gtk_range_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        return (int)gtkAdjustment.value;
    }

    @Override
    long gtk_value_changed(long l) {
        this.postEvent(13);
        return 0L;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_range_set_increments(this.handle, n, this.getPageIncrement());
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        int n2 = this.getMinimum();
        if (n <= n2) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_range_set_range(this.handle, n2, n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int n2 = this.getMaximum();
        if (n >= n2) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_range_set_range(this.handle, n, n2);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_range_set_increments(this.handle, this.getIncrement(), n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setSelection(int n) {
        this.checkWidget();
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_range_set_value(this.handle, n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }
}

