/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.libio.md;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.libio.md.ChargeGroup;
import org.openscience.cdk.libio.md.Residue;

public class MDMolecule
extends Molecule {
    private static final long serialVersionUID = -3129626782945020908L;
    private List residues;
    private List chargeGroups;

    public MDMolecule() {
    }

    public MDMolecule(IAtomContainer container) {
        super(container);
    }

    public List getResidues() {
        return this.residues;
    }

    public void setResidues(List residues) {
        this.residues = residues;
    }

    public void addResidue(Residue residue) {
        if (this.residues == null) {
            this.residues = new ArrayList();
        }
        if (this.residues.contains(residue)) {
            System.out.println("Residue: " + residue.getName() + " already present in molecule: " + this.getID());
            return;
        }
        this.residues.add(residue);
    }

    public List getChargeGroups() {
        return this.chargeGroups;
    }

    public void setChargeGroups(List chargeGroups) {
        this.chargeGroups = chargeGroups;
    }

    public void addChargeGroup(ChargeGroup chargeGroup) {
        if (this.chargeGroups == null) {
            this.chargeGroups = new ArrayList();
        }
        if (this.chargeGroups.contains(chargeGroup)) {
            System.out.println("Charge group: " + chargeGroup.getNumber() + " already present in molecule: " + this.getID());
            return;
        }
        this.chargeGroups.add(chargeGroup);
    }
}

