/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.Iterator;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public abstract class AtomContainerPermutor
implements Iterator<IAtomContainer> {
    static final boolean debug = true;
    static int debugCounter = 0;
    int N;
    int i;
    int j;
    int[] bookkeeping;
    Object[] objects;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(AtomContainerPermutor.class);
    IAtomContainer atomContainer;

    public void setAtomContainer(IAtomContainer ac) {
        this.atomContainer = ac;
    }

    public void initBookkeeping() {
        this.bookkeeping = new int[this.N + 1];
        for (int f = 0; f <= this.N; ++f) {
            this.bookkeeping[f] = f;
        }
        this.i = 1;
    }

    @Override
    public IAtomContainer next() {
        this.bookkeeping[this.i] = this.bookkeeping[this.i] - 1;
        this.j = this.isOdd(this.i) ? this.bookkeeping[this.i] : 0;
        this.swap(this.i, this.j);
        this.i = 1;
        while (this.bookkeeping[this.i] == 0) {
            this.bookkeeping[this.i] = this.i;
            ++this.i;
        }
        return this.makeResult();
    }

    @Override
    public boolean hasNext() {
        return this.i < this.N;
    }

    @Override
    public void remove() {
    }

    void swap(int x, int y) {
        logger.debug("swapping order of " + x + " and " + y);
        Object o = this.objects[x];
        this.objects[x] = this.objects[y];
        this.objects[y] = o;
    }

    void initObjectArray() {
    }

    IAtomContainer makeResult() {
        return null;
    }

    boolean isOdd(int x) {
        return (x & 1) == 1;
    }
}

