/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.openscience.cdk.applications.jchempaint.JChemPaintEditorPanel;
import org.openscience.cdk.dict.DictionaryDatabase;

public class DictionaryDialog
extends JFrame {
    private static final long serialVersionUID = -8933920987749316390L;
    private JEditorPane infoPane;

    public DictionaryDialog() {
        super("Loaded Dictionaries");
        this.createDialog();
        this.displayContent();
        this.pack();
        this.setVisible(true);
    }

    private void createDialog() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setBackground(Color.white);
        Border lb = BorderFactory.createLineBorder(Color.white, 5);
        JTextArea jtf1 = new JTextArea("Loaded Dictionaries");
        jtf1.setBorder(lb);
        jtf1.setEditable(false);
        this.infoPane = new JEditorPane();
        this.infoPane.setEditable(false);
        this.infoPane.setBorder(lb);
        this.infoPane.revalidate();
        JScrollPane scrollPane = new JScrollPane(this.infoPane);
        scrollPane.setPreferredSize(new Dimension(400, 350));
        this.setTitle("Information");
        this.getContentPane().add("Center", scrollPane);
        this.getContentPane().add("North", jtf1);
    }

    private void displayContent() {
        StringBuffer content = new StringBuffer();
        content.append("<html>\n");
        DictionaryDatabase dictdb = JChemPaintEditorPanel.getDictionaryDatabase();
        String[] dicts = dictdb.getDictionaryNames();
        if (dicts.length > 0) {
            content.append("<table>");
            for (int i = 0; i < dicts.length; ++i) {
                String[] entries = dictdb.getDictionaryEntries(dicts[i]);
                for (int j = 0; j < entries.length; ++j) {
                    content.append("<tr>");
                    content.append("<td>" + dicts[i]);
                    content.append("<td>" + entries[j]);
                    content.append("</tr>\n");
                }
            }
            content.append("</table>");
        } else {
            content.append("<p>No dictionaries are loaded.");
        }
        content.append("</html>\n");
        this.infoPane.setContentType("text/html");
        this.infoPane.setText(content.toString());
        this.infoPane.revalidate();
    }
}

