/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Calendar;
import java.util.EventObject;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openscience.cdk.Atom;
import org.openscience.cdk.Bond;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.applications.jchempaint.InsertTextPanel;
import org.openscience.cdk.applications.jchempaint.JCPPropertyHandler;
import org.openscience.cdk.applications.jchempaint.JChemPaintMenuBar;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.JChemPaintPanel;
import org.openscience.cdk.applications.jchempaint.JChemPaintPopupMenu;
import org.openscience.cdk.applications.jchempaint.StatusBar;
import org.openscience.cdk.applications.jchempaint.ToolBarMaker;
import org.openscience.cdk.applications.jchempaint.dnd.JCPTransferHandler;
import org.openscience.cdk.applications.undoredo.IUndoRedoHandler;
import org.openscience.cdk.applications.undoredo.JCPUndoRedoHandler;
import org.openscience.cdk.controller.CDKPopupMenu;
import org.openscience.cdk.controller.PopupController2D;
import org.openscience.cdk.dict.DictionaryDatabase;
import org.openscience.cdk.event.ICDKChangeListener;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.renderer.Renderer2D;
import org.openscience.cdk.renderer.Renderer2DModel;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.LoggingTool;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;
import org.openscience.cdk.tools.manipulator.MoleculeSetManipulator;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import org.openscience.cdk.validate.BasicValidator;
import org.openscience.cdk.validate.CDKValidator;
import org.openscience.cdk.validate.DictionaryValidator;
import org.openscience.cdk.validate.IValidator;
import org.openscience.cdk.validate.PDBValidator;
import org.openscience.cdk.validate.ValencyValidator;
import org.openscience.cdk.validate.ValidatorEngine;

public class JChemPaintEditorPanel
extends JChemPaintPanel
implements ChangeListener,
ICDKChangeListener {
    private static final long serialVersionUID = -5369372292013788887L;
    static String JCP_MODEL_CHANGED = "1";
    static String JCP_CLOSING = "2";
    String lastEventReason;
    String recentSymbol = "C";
    private static DictionaryDatabase dictdb = null;
    private static ValidatorEngine engine = null;
    private static LoggingTool logger;
    boolean showMenuBar = true;
    boolean showToolBar = true;
    boolean showStatusBar = true;
    boolean showInsertTextField = true;
    protected EventListenerList changeListeners = null;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public JChemPaintEditorPanel() {
        this(1, null);
    }

    public JChemPaintEditorPanel(int lines, Dimension panelDimension) {
        this(lines, panelDimension, false, "stable");
    }

    public JChemPaintEditorPanel(int lines, Dimension panelDimension, String guiString) {
        this(lines, panelDimension, false, guiString);
    }

    public JChemPaintEditorPanel(int lines, Dimension panelDimension, boolean isEmbedded, String guiString) {
        if (isEmbedded) {
            this.setEmbedded();
        }
        this.guiString = guiString;
        this.customizeView();
        super.setJChemPaintModel(new JChemPaintModel());
        this.setShowToolBar(true, lines);
        if (!guiString.equals("applet")) {
            this.setShowInsertTextField(true);
        }
        if (logger == null) {
            logger = new LoggingTool((Object)this);
        }
        this.setTransferHandler(new JCPTransferHandler("JCPPanel"));
        logger.debug((Object)"JCPPanel set and done...");
        if (panelDimension != null && this.isEmbedded()) {
            super.getJChemPaintModel().getRendererModel().setBackgroundDimension(panelDimension);
            this.viewerDimension = new Dimension((int)panelDimension.getWidth() + 10, (int)panelDimension.getHeight() + 10);
            super.setPreferredSize(this.viewerDimension);
        }
    }

    public boolean getShowMenuBar() {
        return this.showMenuBar;
    }

    public void setShowMenuBar(boolean showMenuBar) {
        this.showMenuBar = showMenuBar;
        this.customizeView();
    }

    public boolean getShowStatusBar() {
        return this.showStatusBar;
    }

    public boolean getShowInsertTextField() {
        return this.showInsertTextField;
    }

    public void customizeView() {
        if (this.showMenuBar) {
            if (this.menu == null) {
                this.menu = new JChemPaintMenuBar(this, this.guiString);
            }
            this.add((Component)this.menu, "North");
            this.revalidate();
        } else {
            try {
                this.remove(this.menu);
                this.revalidate();
            }
            catch (Exception exc) {
                logger.debug((Object)"Error in removing menu");
            }
        }
        if (this.showStatusBar) {
            if (this.statusBar == null) {
                this.statusBar = new StatusBar();
            }
            this.add((Component)this.statusBar, "South");
            this.revalidate();
        } else {
            try {
                this.remove(this.statusBar);
                this.revalidate();
            }
            catch (Exception exc) {
                logger.debug((Object)"Error in removing status bar");
            }
        }
    }

    void setupIfModelNotEmpty() {
        IAtomContainer ac = ChemModelManipulator.getAllInOneContainer((IChemModel)this.jchemPaintModel.getChemModel());
        Renderer2DModel rendererModel = this.jchemPaintModel.getRendererModel();
        if (ac.getAtomCount() != 0) {
            logger.info((Object)"ChemModel is already non-empty! Sizing things to get it visible!");
            Dimension oneMoleculeDimension = new Dimension(600, 400);
            Dimension dimension = this.makeChemModelFit(oneMoleculeDimension, this.jchemPaintModel.getChemModel());
            rendererModel.setBackgroundDimension(dimension);
            GeometryTools.translateAllPositive((IAtomContainer)ac, (HashMap)rendererModel.getRenderingCoordinates());
            double scaleFactor = GeometryTools.getScaleFactor((IAtomContainer)ac, (double)rendererModel.getBondLength(), (HashMap)this.jchemPaintModel.getRendererModel().getRenderingCoordinates());
            GeometryTools.scaleMolecule((IAtomContainer)ac, (double)scaleFactor, (HashMap)rendererModel.getRenderingCoordinates());
            this.layoutInTable(oneMoleculeDimension, this.jchemPaintModel.getChemModel(), this.jchemPaintModel.getRendererModel());
        }
    }

    public void registerModel(JChemPaintModel model) {
        String filename = "org/openscience/cdk/applications/jchempaint/resources/text/funcgroups.txt";
        InputStream ins = this.getClass().getClassLoader().getResourceAsStream(filename);
        HashMap<String, Molecule> funcgroups = new HashMap<String, Molecule>();
        SmilesParser sp = new SmilesParser();
        StringBuffer sb = new StringBuffer();
        InputStreamReader isr = new InputStreamReader(ins);
        try {
            int i;
            while ((i = isr.read()) != -1) {
                if ((char)i == '\n' || (char)i == '\r') {
                    if (sb.toString().equals("")) continue;
                    StringTokenizer st = new StringTokenizer(sb.toString());
                    String key = (String)st.nextElement();
                    String value = (String)st.nextElement();
                    funcgroups.put(key, sp.parseSmiles(value));
                    funcgroups.put(key.toUpperCase(), sp.parseSmiles(value));
                    sb = new StringBuffer();
                    continue;
                }
                sb.append((char)i);
            }
            if (!sb.toString().equals("")) {
                StringTokenizer st = new StringTokenizer(sb.toString());
                String key = (String)st.nextElement();
                String value = (String)st.nextElement();
                funcgroups.put(key, sp.parseSmiles(value));
                funcgroups.put(key.toUpperCase(), sp.parseSmiles(value));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"cannot instantiate funcgroupsmap", (Object)ex.getMessage());
        }
        PopupController2D inputAdapter = new PopupController2D(model.getChemModel(), model.getRendererModel(), model.getControllerModel(), this.lastAction, this.moveButton, funcgroups);
        JCPUndoRedoHandler undoRedoHandler = new JCPUndoRedoHandler(model.getControllerModel());
        inputAdapter.setUndoRedoHandler((IUndoRedoHandler)undoRedoHandler);
        this.setupPopupMenus(inputAdapter);
        Renderer2DModel rendererModel = model.getRendererModel();
        model.getControllerModel().setBondPointerLength(rendererModel.getBondLength());
        model.getControllerModel().setRingPointerLength(rendererModel.getBondLength());
        model.getRendererModel().addCDKChangeListener((ICDKChangeListener)this);
        inputAdapter.addCDKChangeListener((ICDKChangeListener)model);
        this.drawingPanel.addMouseListener((MouseListener)inputAdapter);
        this.drawingPanel.addMouseMotionListener((MouseMotionListener)inputAdapter);
        this.drawingPanel.addKeyListener((KeyListener)inputAdapter);
    }

    public boolean getShowToolBar() {
        return this.showToolBar;
    }

    public String getLastEventReason() {
        return this.lastEventReason;
    }

    public void setLastEventReason(String lastEventReason) {
        this.lastEventReason = lastEventReason;
    }

    public void setShowToolBar(boolean showToolBar) {
        this.setShowToolBar(showToolBar, 1);
    }

    public void setShowStatusBar(boolean showStatusBar) {
        this.showStatusBar = showStatusBar;
        this.customizeView();
    }

    public void setShowInsertTextField(boolean showInsertTextField) {
        this.showInsertTextField = showInsertTextField;
        if (showInsertTextField) {
            if (this.insertTextPanel == null) {
                this.insertTextPanel = new InsertTextPanel(this, null);
            }
            this.topContainer.add((Component)this.insertTextPanel, "South");
        } else {
            this.topContainer.remove(this.insertTextPanel);
        }
        this.mainContainer.revalidate();
    }

    public void setShowToolBar(boolean showToolBar, int lines) {
        this.showToolBar = showToolBar;
        if (showToolBar) {
            if (this.toolBar == null) {
                this.toolBar = ToolBarMaker.getToolbar(this, lines);
            }
            this.topContainer.add((Component)this.toolBar, "North");
            this.mainContainer.revalidate();
        } else {
            try {
                this.topContainer.remove(this.toolBar);
                this.mainContainer.revalidate();
            }
            catch (Exception exc) {
                logger.debug((Object)"Error in removing tool bar");
            }
        }
    }

    public Color getBackground() {
        if (this.jchemPaintModel != null) {
            return this.jchemPaintModel.getRendererModel().getBackColor();
        }
        return Color.WHITE;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public JChemPaintMenuBar getMenu() {
        return this.menu;
    }

    public static JFrame getEmptyFrameWithModel() {
        JChemPaintModel model = new JChemPaintModel();
        model.setTitle(JChemPaintEditorPanel.getNewFrameName());
        model.setAuthor(JCPPropertyHandler.getInstance().getJCPProperties().getProperty("General.UserName"));
        Package self = Package.getPackage("org.openscience.cdk.applications.jchempaint");
        String version = self.getImplementationVersion();
        model.setSoftware("JChemPaint " + version);
        model.setGendate(Calendar.getInstance().getTime().toString());
        JFrame jcpf = JChemPaintEditorPanel.getNewFrame(model);
        return jcpf;
    }

    public static JFrame getFrameWithModel(IChemModel mod) {
        JChemPaintModel model = new JChemPaintModel(mod);
        model.setTitle(mod.getID());
        model.setAuthor(JCPPropertyHandler.getInstance().getJCPProperties().getProperty("General.UserName"));
        Package self = Package.getPackage("org.openscience.cdk.applications.jchempaint");
        String version = self.getImplementationVersion();
        model.setSoftware("JChemPaint " + version);
        model.setGendate(Calendar.getInstance().getTime().toString());
        JFrame jcpf = JChemPaintEditorPanel.getNewFrame(model);
        return jcpf;
    }

    public static JFrame getNewFrame(JChemPaintModel model) {
        JFrame frame = new JFrame();
        frame.addWindowListener(new JChemPaintPanel.AppCloser());
        frame.setDefaultCloseOperation(0);
        JChemPaintEditorPanel jcpep = new JChemPaintEditorPanel();
        frame.getContentPane().add(jcpep);
        jcpep.registerModel(model);
        jcpep.setJChemPaintModel(model);
        frame.setTitle(model.getTitle());
        frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                if (((JChemPaintEditorPanel)((JFrame)e.getSource()).getContentPane().getComponent((int)0)).getJChemPaintModel().getRendererModel().getBackgroundDimension().width < ((JFrame)e.getSource()).getWidth() - 30) {
                    ((JChemPaintEditorPanel)((JFrame)e.getSource()).getContentPane().getComponent(0)).getJChemPaintModel().getRendererModel().setBackgroundDimension(new Dimension(((JFrame)e.getSource()).getWidth() - 30, ((JChemPaintEditorPanel)((JFrame)e.getSource()).getContentPane().getComponent((int)0)).getJChemPaintModel().getRendererModel().getBackgroundDimension().height));
                }
                if (((JChemPaintEditorPanel)((JFrame)e.getSource()).getContentPane().getComponent((int)0)).getJChemPaintModel().getRendererModel().getBackgroundDimension().height < ((JFrame)e.getSource()).getHeight() - 30) {
                    ((JChemPaintEditorPanel)((JFrame)e.getSource()).getContentPane().getComponent(0)).getJChemPaintModel().getRendererModel().setBackgroundDimension(new Dimension(((JChemPaintEditorPanel)((JFrame)e.getSource()).getContentPane().getComponent((int)0)).getJChemPaintModel().getRendererModel().getBackgroundDimension().width, ((JFrame)e.getSource()).getHeight() - 30));
                }
            }
        });
        model.getControllerModel().setAutoUpdateImplicitHydrogens(true);
        model.getRendererModel().setShowEndCarbons(true);
        return frame;
    }

    public void setupPopupMenus(PopupController2D inputAdapter) {
        if (inputAdapter.getPopupMenu((IChemObject)new Atom("H")) == null) {
            inputAdapter.setPopupMenu((IChemObject)new Atom("H"), (CDKPopupMenu)new JChemPaintPopupMenu(this, "atom"));
        }
        if (inputAdapter.getPopupMenu((IChemObject)new PseudoAtom("R")) == null) {
            inputAdapter.setPopupMenu((IChemObject)new PseudoAtom("R"), (CDKPopupMenu)new JChemPaintPopupMenu(this, "pseudo"));
        }
        if (inputAdapter.getPopupMenu((IChemObject)new Bond()) == null) {
            inputAdapter.setPopupMenu((IChemObject)new Bond(), (CDKPopupMenu)new JChemPaintPopupMenu(this, "bond"));
        }
        if (inputAdapter.getPopupMenu((IChemObject)new ChemModel()) == null) {
            inputAdapter.setPopupMenu((IChemObject)new ChemModel(), (CDKPopupMenu)new JChemPaintPopupMenu(this, "chemmodel"));
        }
        if (inputAdapter.getPopupMenu((IChemObject)new Reaction()) == null) {
            inputAdapter.setPopupMenu((IChemObject)new Reaction(), (CDKPopupMenu)new JChemPaintPopupMenu(this, "reaction"));
        }
    }

    public Image takeSnapshot() {
        Image snapImage = null;
        try {
            logger.info((Object)"Making snapshot... ");
            Renderer2D r2d = new Renderer2D(this.jchemPaintModel.getRendererModel());
            r2d.setRenderer2DModel(this.jchemPaintModel.getRendererModel());
            IChemModel model = null;
            try {
                model = (IChemModel)this.jchemPaintModel.getChemModel().clone();
            }
            catch (CloneNotSupportedException exception) {
                logger.error((Object)"Clone of IChemModel failed: ", (Object)exception.getMessage());
                logger.debug((Object)exception);
                return null;
            }
            IAtomContainer ac = MoleculeSetManipulator.getAllInOneContainer((IMoleculeSet)model.getMoleculeSet());
            Dimension dim = GeometryTools.get2DDimension((IAtomContainer)ac, (HashMap)this.jchemPaintModel.getRendererModel().getRenderingCoordinates());
            GeometryTools.translateAllPositive((IAtomContainer)ac, (HashMap)this.jchemPaintModel.getRendererModel().getRenderingCoordinates());
            snapImage = this.createImage((int)dim.getWidth() + 20, (int)dim.getHeight() + 20);
            Graphics2D snapGraphics = (Graphics2D)snapImage.getGraphics();
            snapGraphics.setBackground(Color.WHITE);
            snapGraphics.clearRect(0, 0, (int)dim.getWidth() + 20, (int)dim.getHeight() + 20);
            r2d.useScreenSize = false;
            r2d.paintMolecule(ac, snapGraphics, false, true);
            r2d.useScreenSize = true;
            logger.info((Object)"created...");
            logger.debug((Object)"painting succeeded.");
        }
        catch (NullPointerException e) {
            snapImage = null;
        }
        return snapImage;
    }

    public void stateChanged(EventObject e) {
        this.drawingPanel.repaint();
    }

    private Dimension makeChemModelFit(Dimension baseDim, IChemModel model) {
        Dimension newDim = new Dimension(baseDim);
        IMoleculeSet moleculeSet = model.getMoleculeSet();
        if (moleculeSet != null) {
            newDim.height *= moleculeSet.getMoleculeCount();
            return newDim;
        }
        IReactionSet reactionSet = model.getReactionSet();
        if (reactionSet != null) {
            newDim.height *= reactionSet.getReactionCount();
        }
        return newDim;
    }

    private void layoutInTable(Dimension baseDim, IChemModel model, Renderer2DModel rm) {
        IMoleculeSet moleculeSet = model.getMoleculeSet();
        if (moleculeSet != null) {
            for (int i = 0; i < moleculeSet.getAtomContainerCount(); ++i) {
                GeometryTools.center((IAtomContainer)moleculeSet.getAtomContainer(i), (Dimension)baseDim, (HashMap)rm.getRenderingCoordinates());
                GeometryTools.translate2D((IAtomContainer)moleculeSet.getAtomContainer(i), (double)0.0, (double)(baseDim.height * i), (HashMap)rm.getRenderingCoordinates());
            }
            return;
        }
        IReactionSet reactionSet = model.getReactionSet();
        if (reactionSet != null) {
            for (int i = 1; i <= reactionSet.getReactionCount(); ++i) {
                IAtomContainer ac = ReactionManipulator.getAllInOneContainer((IReaction)reactionSet.getReaction(i - 1));
                GeometryTools.center((IAtomContainer)ac, (Dimension)baseDim, (HashMap)rm.getRenderingCoordinates());
                GeometryTools.translate2D((IAtomContainer)ac, (double)0.0, (double)(baseDim.height * (reactionSet.getReactionCount() - i)), (HashMap)rm.getRenderingCoordinates());
            }
        }
    }

    public static ValidatorEngine getValidatorEngine() {
        if (engine == null) {
            engine = new ValidatorEngine();
            engine.addValidator((IValidator)new BasicValidator());
            engine.addValidator((IValidator)new ValencyValidator());
            engine.addValidator((IValidator)new CDKValidator());
            engine.addValidator((IValidator)new DictionaryValidator(dictdb));
            engine.addValidator((IValidator)new PDBValidator());
        }
        return engine;
    }

    public static DictionaryDatabase getDictionaryDatabase() {
        if (dictdb == null) {
            dictdb = new DictionaryDatabase();
            try {
                Object dicts;
                File dictdir = new File(JCPPropertyHandler.getInstance().getJChemPaintDir(), "dicts");
                logger.info((Object)"User dict dir: ", (Object)dictdir);
                logger.debug((Object)"       exists: ", dictdir.exists());
                logger.debug((Object)"  isDirectory: ", dictdir.isDirectory());
                if (dictdir.exists() && dictdir.isDirectory()) {
                    dicts = dictdir.listFiles();
                    for (int i = 0; i < ((Object)dicts).length; ++i) {
                        try {
                            FileReader reader = new FileReader((File)dicts[i]);
                            String filename = ((File)dicts[i]).getName();
                            dictdb.readDictionary((Reader)reader, filename.substring(0, filename.indexOf(46)));
                            continue;
                        }
                        catch (IOException exception) {
                            logger.error((Object)"Problem with reading macie dictionary...");
                        }
                    }
                }
                logger.info((Object)"Read these dictionaries: ");
                dicts = dictdb.listDictionaries();
                while (dicts.hasMoreElements()) {
                    logger.info((Object)" - ", (Object)dicts.nextElement().toString());
                }
            }
            catch (Exception exc) {
                logger.error((Object)"Could not handle dictionary initialization. Maybe I'm running in a sandbox.");
            }
        }
        return dictdb;
    }

    public String getAPIVersion() {
        return "1.8";
    }

    public void runScript(String s1, String s2) {
        logger.info((Object)"runScript method currently not supported");
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JChemPaintPanel) {
            IChemModel editorModel = ((JChemPaintPanel)e.getSource()).getJChemPaintModel().getChemModel();
            JViewport viewPort = ((JScrollPane)((Container)this.getComponent(0)).getComponent(0)).getViewport();
            if (viewPort.getView() == null) {
                viewPort.add(this.getDrawingPanel());
            }
            this.getJChemPaintModel().setChemModel(editorModel);
            if (editorModel != null) {
                this.scaleAndCenterMolecule(this.getJChemPaintModel().getChemModel());
            }
        }
        super.stateChanged(e);
        if (this.jchemPaintModel != null) {
            for (int i = 0; i < 3; ++i) {
                String status = this.jchemPaintModel.getStatus(i);
                this.statusBar.setStatus(i + 1, status);
            }
        } else if (this.statusBar != null) {
            this.statusBar.setStatus(1, "no model");
        }
    }

    public void addChangeListener(ChangeListener x) {
        if (this.changeListeners == null) {
            this.changeListeners = new EventListenerList();
        }
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JChemPaintEditorPanel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, x);
        x.stateChanged(new ChangeEvent(this));
    }

    public void removeChangeListener(ChangeListener x) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JChemPaintEditorPanel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, x);
    }

    protected void fireChange(String reason) {
        this.lastEventReason = reason;
        ChangeEvent c = new ChangeEvent(this);
        if (this.changeListeners != null) {
            Object[] listeners = this.changeListeners.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$ChangeListener == null ? JChemPaintEditorPanel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
                ChangeListener cl = (ChangeListener)listeners[i + 1];
                cl.stateChanged(c);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

