/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.openscience.jmol.app.ConsoleTextPane;

class ConsoleDocument
extends DefaultStyledDocument {
    ConsoleTextPane consoleTextPane;
    SimpleAttributeSet attError = new SimpleAttributeSet();
    SimpleAttributeSet attEcho;
    SimpleAttributeSet attPrompt;
    SimpleAttributeSet attUserInput;
    SimpleAttributeSet attStatus;
    Position positionBeforePrompt;
    Position positionAfterPrompt;
    int offsetAfterPrompt;

    ConsoleDocument() {
        StyleConstants.setForeground(this.attError, Color.red);
        this.attPrompt = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attPrompt, Color.magenta);
        this.attUserInput = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attUserInput, Color.black);
        this.attEcho = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attEcho, Color.blue);
        StyleConstants.setBold(this.attEcho, true);
        this.attStatus = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attStatus, Color.black);
        StyleConstants.setItalic(this.attStatus, true);
    }

    void setConsoleTextPane(ConsoleTextPane consoleTextPane) {
        this.consoleTextPane = consoleTextPane;
    }

    void clearContent() {
        try {
            super.remove(0, this.getLength());
        }
        catch (BadLocationException exception) {
            System.out.println("Could not clear script window content: " + exception.getMessage());
        }
    }

    void setPrompt() {
        try {
            super.insertString(this.getLength(), "$ ", this.attPrompt);
            this.setOffsetPositions();
            this.consoleTextPane.setCaretPosition(this.offsetAfterPrompt);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    void setOffsetPositions() {
        try {
            this.offsetAfterPrompt = this.getLength();
            this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt - 2);
            this.positionAfterPrompt = this.createPosition(this.offsetAfterPrompt - 1);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    void setNoPrompt() {
        try {
            this.offsetAfterPrompt = this.getLength();
            this.positionAfterPrompt = this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt);
            this.consoleTextPane.setCaretPosition(this.offsetAfterPrompt);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    void outputBeforePrompt(String str, SimpleAttributeSet attribute) {
        try {
            int pt = this.consoleTextPane.getCaretPosition();
            Position caretPosition = this.createPosition(pt);
            pt = this.positionBeforePrompt.getOffset();
            super.insertString(pt, str + "\n", attribute);
            this.setOffsetPositions();
            pt = caretPosition.getOffset();
            this.consoleTextPane.setCaretPosition(pt);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    void outputError(String strError) {
        this.outputBeforePrompt(strError, this.attError);
    }

    void outputErrorForeground(String strError) {
        try {
            super.insertString(this.getLength(), strError + "\n", this.attError);
            this.consoleTextPane.setCaretPosition(this.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    void outputEcho(String strEcho) {
        this.outputBeforePrompt(strEcho, this.attEcho);
    }

    void outputStatus(String strStatus) {
        this.outputBeforePrompt(strStatus, this.attStatus);
    }

    void appendNewline() {
        try {
            super.insertString(this.getLength(), "\n", this.attUserInput);
            this.consoleTextPane.setCaretPosition(this.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        int ichNewline = str.indexOf(10);
        if (ichNewline > 0) {
            str = str.substring(0, ichNewline);
        }
        if (ichNewline != 0) {
            if (offs < this.offsetAfterPrompt) {
                offs = this.getLength();
            }
            super.insertString(offs, str, a == this.attError ? a : this.attUserInput);
            this.consoleTextPane.setCaretPosition(offs + str.length());
        }
        if (ichNewline >= 0) {
            this.consoleTextPane.enterPressed();
        }
    }

    String getCommandString() {
        String strCommand = "";
        try {
            int cmdStart = this.positionAfterPrompt.getOffset();
            strCommand = this.getText(cmdStart, this.getLength() - cmdStart).trim();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return strCommand;
    }

    public void remove(int offs, int len) throws BadLocationException {
        if (offs < this.offsetAfterPrompt) {
            if ((len -= this.offsetAfterPrompt - offs) <= 0) {
                return;
            }
            offs = this.offsetAfterPrompt;
        }
        super.remove(offs, len);
    }

    public void replace(int offs, int length, String str, AttributeSet attrs) throws BadLocationException {
        if (offs < this.offsetAfterPrompt) {
            if (offs + length < this.offsetAfterPrompt) {
                offs = this.getLength();
                length = 0;
            } else {
                length -= this.offsetAfterPrompt - offs;
                offs = this.offsetAfterPrompt;
            }
        }
        super.replace(offs, length, str, attrs);
    }

    void replaceCommand(String newCommand, boolean isError) throws BadLocationException {
        if (this.positionAfterPrompt == this.positionBeforePrompt) {
            return;
        }
        this.replace(this.offsetAfterPrompt, this.getLength() - this.offsetAfterPrompt, newCommand, isError ? this.attError : this.attUserInput);
    }
}

