/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Bond;
import org.jmol.viewer.BondIterator;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Shape;

class Sticks
extends Shape {
    final float[] connectDistances = new float[2];
    int connectDistanceCount;
    final BitSet[] connectSets = new BitSet[2];
    int connectSetCount;
    short connectBondOrder;
    int connectOperation;
    private static final float DEFAULT_MAX_CONNECT_DISTANCE = 1.0E8f;
    private static final float DEFAULT_MIN_CONNECT_DISTANCE = 0.1f;

    Sticks() {
    }

    void setSize(int size, BitSet bsSelected) {
        short mad = (short)size;
        this.setMadBond(mad, (short)3, bsSelected);
    }

    void setProperty(String propertyName, Object value, BitSet bsSelected) {
        Logger.debug(propertyName + " " + value + " " + bsSelected);
        if ("color" == propertyName) {
            short colix;
            this.setColixBond(colix, (colix = Graphics3D.getColix(value)) != 3 ? null : (String)value, (short)3, bsSelected);
            return;
        }
        if ("translucency" == propertyName) {
            this.setTranslucencyBond(value == "translucent", (short)3, bsSelected);
            return;
        }
        if ("resetConnectParameters" == propertyName) {
            this.connectDistanceCount = 0;
            this.connectSetCount = 0;
            this.connectBondOrder = (short)-1;
            this.connectOperation = 3;
            return;
        }
        if ("connectDistance" == propertyName) {
            if (this.connectDistanceCount < this.connectDistances.length) {
                this.connectDistances[this.connectDistanceCount++] = ((Float)value).floatValue();
            } else {
                Logger.error("too many connect distances specified");
            }
            return;
        }
        if ("connectSet" == propertyName) {
            if (this.connectSetCount < this.connectSets.length) {
                this.connectSets[this.connectSetCount++] = (BitSet)value;
            } else {
                Logger.error("too many connect sets specified");
            }
            return;
        }
        if ("connectBondOrder" == propertyName) {
            this.connectBondOrder = JmolConstants.getBondOrderFromString((String)value);
            return;
        }
        if ("connectOperation" == propertyName) {
            this.connectOperation = JmolConstants.connectOperationFromString((String)value);
            return;
        }
        if ("applyConnectParameters" == propertyName) {
            if (this.connectDistanceCount < 2) {
                if (this.connectDistanceCount == 0) {
                    this.connectDistances[0] = 1.0E8f;
                }
                this.connectDistances[1] = this.connectDistances[0];
                this.connectDistances[0] = 0.1f;
            }
            if (this.connectSetCount < 2) {
                if (this.connectSetCount == 0) {
                    this.connectSets[0] = bsSelected;
                }
                this.connectSets[1] = this.connectSets[0];
                this.connectSets[0] = bsSelected;
            }
            if (this.connectOperation >= 0) {
                this.frame.makeConnections(this.connectDistances[0], this.connectDistances[1], this.connectBondOrder, this.connectOperation, this.connectSets[0], this.connectSets[1]);
            }
            return;
        }
        if ("rasmolCompatibleConnect" == propertyName) {
            this.frame.deleteAllBonds();
            this.frame.autoBond(null, null);
            return;
        }
        super.setProperty(propertyName, value, bsSelected);
    }

    void setMadBond(short mad, short bondTypeMask, BitSet bs) {
        BondIterator iter = this.frame.getBondIterator(bondTypeMask, bs);
        while (iter.hasNext()) {
            iter.next().setMad(mad);
        }
    }

    void setColixBond(short colix, String palette, short bondTypeMask, BitSet bs) {
        if (colix != 3) {
            BondIterator iter = this.frame.getBondIterator(bondTypeMask, bs);
            while (iter.hasNext()) {
                iter.next().setColix(colix);
            }
        } else {
            Logger.error("setColixBond called with palette:" + palette);
        }
    }

    void setTranslucencyBond(boolean isTranslucent, short bondTypeMask, BitSet bs) {
        BondIterator iter = this.frame.getBondIterator(bondTypeMask, bs);
        while (iter.hasNext()) {
            iter.next().setTranslucent(isTranslucent);
        }
    }

    void setModelClickability() {
        Bond[] bonds = this.frame.bonds;
        int i = this.frame.bondCount;
        while (--i >= 0) {
            Bond bond = bonds[i];
            if ((bond.shapeVisibilityFlags & this.myVisibilityFlag) == 0 || this.frame.bsHidden.get(bond.atom1.atomIndex) || this.frame.bsHidden.get(bond.atom2.atomIndex)) continue;
            bond.atom1.clickabilityFlags |= this.myVisibilityFlag;
            bond.atom2.clickabilityFlags |= this.myVisibilityFlag;
        }
    }
}

