/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Text;
import org.jmol.viewer.TextShape;

class Hover
extends TextShape {
    private static final String FONTFACE = "SansSerif";
    private static final String FONTSTYLE = "Plain";
    private static final int FONTSIZE = 12;
    Text hoverText;
    int atomIndex = -1;
    String labelFormat = "%U";

    Hover() {
    }

    void initShape() {
        Font3D font3d = this.g3d.getFont3D(FONTFACE, FONTSTYLE, 12);
        short bgcolix = Graphics3D.getColix("#FFFFC3");
        short colix = 4;
        this.currentText = this.hoverText = new Text(this.g3d, font3d, null, colix, bgcolix, 0, 0, 1, Integer.MIN_VALUE, 1);
        this.hoverText.setAdjustForWindow(true);
    }

    void setProperty(String propertyName, Object value, BitSet bsSelected) {
        Logger.debug("Hover.setProperty(" + propertyName + "," + value + ")");
        if ("target" == propertyName) {
            if (value == null) {
                this.atomIndex = -1;
            } else {
                this.atomIndex = (Integer)value;
                this.viewer.setStatusAtomHovered(this.atomIndex, this.viewer.getAtomInfoXYZ(this.atomIndex));
            }
            return;
        }
        if ("label" == propertyName) {
            this.labelFormat = (String)value;
            if (this.labelFormat != null && this.labelFormat.length() == 0) {
                this.labelFormat = null;
            }
            return;
        }
        super.setProperty(propertyName, value, null);
    }
}

