/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Backbone;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.Mps;
import org.jmol.viewer.MpsRenderer;

class BackboneRenderer
extends MpsRenderer {
    int myVisibilityFlag;

    BackboneRenderer() {
    }

    void renderMpspolymer(Mps.Mpspolymer mpspolymer, int myVisibilityFlag) {
        this.myVisibilityFlag = myVisibilityFlag;
        this.renderBackboneChain((Backbone.Bbpolymer)mpspolymer);
    }

    void renderBackboneChain(Backbone.Bbpolymer bbpolymer) {
        this.render1Chain(bbpolymer.monomerCount, bbpolymer.monomers, bbpolymer.polymer.getLeadAtomIndices(), bbpolymer.mads, bbpolymer.colixes);
    }

    void render1Chain(int monomerCount, Monomer[] monomers, int[] atomIndices, short[] mads, short[] colixes) {
        int i = monomerCount - 1;
        while (--i >= 0) {
            if ((monomers[i].shapeVisibilityFlags & this.myVisibilityFlag) == 0) continue;
            Atom atomA = this.frame.getAtomAt(atomIndices[i]);
            Atom atomB = this.frame.getAtomAt(atomIndices[i + 1]);
            if (atomA.nBackbonesDisplayed == 0 || atomB.nBackbonesDisplayed == 0 || this.frame.bsHidden.get(atomA.atomIndex) || this.frame.bsHidden.get(atomB.atomIndex)) continue;
            int xA = atomA.getScreenX();
            int yA = atomA.getScreenY();
            int zA = atomA.getScreenZ();
            int xB = atomB.getScreenX();
            int yB = atomB.getScreenY();
            int zB = atomB.getScreenZ();
            short colixA = Graphics3D.inheritColix(colixes[i], atomA.colixAtom);
            short colixB = Graphics3D.inheritColix(colixes[i + 1], atomB.colixAtom);
            if (mads[i] < 0) {
                this.g3d.drawLine(colixA, colixB, xA, yA, zA, xB, yB, zB);
                continue;
            }
            short width = this.viewer.scaleToScreen((zA + zB) / 2, mads[i]);
            this.g3d.fillCylinder(colixA, colixB, (byte)3, width, xA, yA, zA, xB, yB, zB);
        }
    }
}

