/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.PrintStream;
import org.jmol.util.Logger;
import org.jmol.util.LoggerInterface;

public class DefaultLogger
implements LoggerInterface {
    public static void log(PrintStream out, int level, String txt, Throwable e) {
        if (out != null && (txt != null || e != null)) {
            StackTraceElement[] elements;
            txt = txt != null ? txt : "";
            out.println((Logger.logLevel() ? "[" + Logger.getLevel(level) + "] " : "") + txt + (e != null ? ": " + e.getMessage() : ""));
            if (e != null && (elements = e.getStackTrace()) != null) {
                for (int i = 0; i < elements.length; ++i) {
                    out.println(elements[i].getClassName() + " - " + elements[i].getLineNumber() + " - " + elements[i].getMethodName());
                }
            }
        }
    }

    public void debug(String txt) {
        DefaultLogger.log(System.out, 0, txt, null);
    }

    public void info(String txt) {
        DefaultLogger.log(System.out, 1, txt, null);
    }

    public void warn(String txt) {
        DefaultLogger.log(System.out, 2, txt, null);
    }

    public void warn(String txt, Throwable e) {
        DefaultLogger.log(System.out, 2, txt, e);
    }

    public void error(String txt) {
        DefaultLogger.log(System.err, 3, txt, null);
    }

    public void error(String txt, Throwable e) {
        DefaultLogger.log(System.err, 3, txt, e);
    }

    public void fatal(String txt) {
        DefaultLogger.log(System.err, 4, txt, null);
    }

    public void fatal(String txt, Throwable e) {
        DefaultLogger.log(System.err, 4, txt, e);
    }
}

