/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

class HinReader
extends AtomSetCollectionReader {
    String errorMessage;
    int atomIndex;
    int baseAtomIndex;
    String[] tokens;
    static final int MAX_TOKENS = 40;

    HinReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("hin");
        this.readAtoms();
        if (this.errorMessage != null) {
            this.atomSetCollection.errorMessage = this.errorMessage;
        } else if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        }
        return this.atomSetCollection;
    }

    void readAtoms() throws Exception {
        this.tokens = new String[40];
        this.errorMessage = null;
        while (this.errorMessage == null && this.readLine() != null) {
            if (this.line.length() == 0 || this.line.charAt(0) == ';') continue;
            if (this.line.startsWith("mol ")) {
                this.processMol();
                continue;
            }
            if (this.line.startsWith("atom ")) {
                this.processAtom();
                continue;
            }
            if (!this.line.startsWith("endmol ")) continue;
            this.processEndmol();
        }
        this.tokens = null;
    }

    void processMol() {
        this.atomSetCollection.newAtomSet();
        String molName = this.getMolName();
        this.atomSetCollection.setAtomSetName(molName);
        this.atomIndex = 0;
        this.baseAtomIndex = this.atomSetCollection.atomCount;
    }

    String getMolName() {
        this.parseToken(this.line);
        this.parseToken(this.line, this.ichNextParse);
        return this.parseToken(this.line, this.ichNextParse);
    }

    void processAtom() {
        int fileAtomNumber = this.parseInt(this.line, 5);
        if (fileAtomNumber - 1 != this.atomIndex) {
            this.errorMessage = "bad atom number sequence ... expected:" + (this.atomIndex + 1) + " found:" + fileAtomNumber;
            return;
        }
        Atom atom = this.atomSetCollection.addNewAtom();
        this.parseToken(this.line, this.ichNextParse);
        atom.elementSymbol = this.parseToken(this.line, this.ichNextParse);
        this.parseToken(this.line, this.ichNextParse);
        this.parseToken(this.line, this.ichNextParse);
        atom.partialCharge = this.parseFloat(this.line, this.ichNextParse);
        atom.x = this.parseFloat(this.line, this.ichNextParse);
        atom.y = this.parseFloat(this.line, this.ichNextParse);
        atom.z = this.parseFloat(this.line, this.ichNextParse);
        int bondCount = this.parseInt(this.line, this.ichNextParse);
        for (int i = 0; i < bondCount; ++i) {
            int bondOrder;
            int otherAtomNumber = this.parseInt(this.line, this.ichNextParse);
            String bondTypeToken = this.parseToken(this.line, this.ichNextParse);
            if (otherAtomNumber > this.atomIndex) continue;
            switch (bondTypeToken.charAt(0)) {
                case 's': {
                    bondOrder = 1;
                    break;
                }
                case 'd': {
                    bondOrder = 2;
                    break;
                }
                case 't': {
                    bondOrder = 3;
                    break;
                }
                case 'a': {
                    bondOrder = 4;
                    break;
                }
                default: {
                    this.errorMessage = "unrecognized bond type:" + bondTypeToken + " atom #" + fileAtomNumber;
                    return;
                }
            }
            this.atomSetCollection.addNewBond(this.baseAtomIndex + this.atomIndex, this.baseAtomIndex + otherAtomNumber - 1, bondOrder);
        }
        ++this.atomIndex;
    }

    void processEndmol() {
    }
}

