/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.view;

import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.guha.rcdk.view.RowLabelRenderer;
import org.guha.rcdk.view.panels.Render2DPanel;
import org.guha.rcdk.view.table.StructureTableCellEditor2D;
import org.guha.rcdk.view.table.StructureTableCellRenderer2D;
import org.guha.rcdk.view.table.StructureTableModel;
import org.openscience.cdk.interfaces.IAtomContainer;

class StructureTable2D {
    private IAtomContainer[] v;
    boolean withHydrogen = true;
    private int cellx = 200;
    private int celly = 200;
    private int ncol = 4;

    public StructureTable2D(IAtomContainer[] structs) {
        this.v = structs;
    }

    public StructureTable2D(IAtomContainer[] structs, int ncol, boolean withHydrogen) {
        this.v = structs;
        this.ncol = ncol;
        this.withHydrogen = withHydrogen;
    }

    public StructureTable2D(IAtomContainer[] structs, int ncol, int cellx, int celly, boolean withHydrogen) {
        this.v = structs;
        this.ncol = ncol;
        this.cellx = cellx;
        this.celly = celly;
        this.withHydrogen = withHydrogen;
    }

    public void display() {
        int i = 0;
        int j = 0;
        int pad = 10;
        String[] nm = new String[this.ncol + 1];
        int extra = this.v.length % this.ncol;
        int block = this.v.length - extra;
        int nrow = block / this.ncol;
        Object[][] ndata = extra == 0 ? new Object[nrow][this.ncol + 1] : new Object[nrow + 1][this.ncol + 1];
        int cnt = 0;
        for (i = 0; i < nrow; ++i) {
            for (j = 1; j < this.ncol + 1; ++j) {
                ndata[i][j] = new Render2DPanel(this.v[cnt], this.cellx, this.celly, this.withHydrogen);
                ++cnt;
            }
        }
        j = 1;
        while (cnt < this.v.length) {
            ndata[nrow][j] = new Render2DPanel(this.v[cnt], this.cellx, this.celly, this.withHydrogen);
            ++cnt;
            ++j;
        }
        if (extra != 0) {
            ++nrow;
        }
        for (i = 0; i < nrow; ++i) {
            ndata[i][0] = i * this.ncol + 1;
        }
        JFrame frame = new JFrame("2D Structure Grid");
        frame.setDefaultCloseOperation(2);
        JTable mtable = new JTable(new StructureTableModel(ndata, nm));
        mtable.setShowGrid(true);
        for (i = 0; i < nrow; ++i) {
            mtable.setRowHeight(i, this.celly);
        }
        mtable.setColumnSelectionAllowed(false);
        mtable.setRowSelectionAllowed(false);
        TableColumn col = mtable.getColumnModel().getColumn(0);
        col.setCellRenderer(new RowLabelRenderer());
        for (i = 1; i < this.ncol + 1; ++i) {
            col = mtable.getColumnModel().getColumn(i);
            col.setCellRenderer(new StructureTableCellRenderer2D());
            col.setCellEditor(new StructureTableCellEditor2D());
        }
        JScrollPane scrollpane = new JScrollPane(mtable, 20, 30);
        if (nrow > 3) {
            mtable.setPreferredScrollableViewportSize(new Dimension(this.ncol * this.cellx + pad, 3 * this.celly + pad));
        } else {
            mtable.setPreferredScrollableViewportSize(new Dimension(this.ncol * this.cellx + pad, nrow * this.celly + pad));
        }
        frame.getContentPane().add(scrollpane);
        frame.pack();
        if (nrow > 3) {
            frame.setSize(this.ncol * this.cellx + pad, 3 * this.celly + pad);
        } else {
            frame.setSize(this.ncol * this.cellx + pad, nrow * this.celly + pad);
        }
        frame.setVisible(true);
    }
}

