% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.SpdPermTest}
\alias{plot.SpdPermTest}
\title{Plot result of mark permutation test of SPDs}
\usage{
\method{plot}{SpdPermTest}(x, focalm = "1", calendar = "BP", xlim = NA,
  ylim = NA, col.obs = "black", col.env = rgb(0, 0, 0, 0.2),
  lwd.obs = 0.5, xaxs = "i", yaxs = "i", bbty = "f", drawaxes = TRUE,
  ...)
}
\arguments{
\item{x}{A \code{SpdPermTest} class object. Result of random mark permutation test (see \code{\link{permTest}})}

\item{focalm}{Value specifying the name of the focal mark (group) to be plotted.}

\item{calendar}{Either \code{'BP'} or \code{'BCAD'}. Indicate whether the calibrated date should be displayed in BP or BC/AD. Default is  \code{'BP'}.}

\item{xlim}{the x limits of the plot.}

\item{ylim}{the y limits of the plot.}

\item{col.obs}{Line colour for the observed SPD}

\item{col.env}{Colour for the simulation envelope}

\item{lwd.obs}{Line width for the observed SPD}

\item{xaxs}{The style of x-axis interval calculation (see \code{\link{par}})}

\item{yaxs}{The style of y-axis interval calculation (see \code{\link{par}})}

\item{bbty}{Display options; one between \code{'b'},\code{'n'},and \code{'f'}. See details in \code{\link{plot.SpdModelTest}}.}

\item{drawaxes}{A logical value determining whether the axes should be displayed or not. Default is TRUE.}

\item{...}{Additional arguments affecting the plot}
}
\description{
Visualises the observed SPD along with the simulation envelope generated from \code{\link{permTest}}, with regions of positive and negative deviations highlighted in red and blue.
}
\seealso{
\code{\link{permTest}}; \code{\link{plot.SpdModelTest}};
}
