% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_sky_pixels_nonnull.R
\name{find_sky_pixels_nonnull}
\alias{find_sky_pixels_nonnull}
\title{Find sky pixels following the non-null criteria}
\usage{
find_sky_pixels_nonnull(r, sky, g, intercept = 0, slope = 1, w = 0.5)
}
\arguments{
\item{r}{\linkS4class{SpatRaster}. A normalized greyscale image. Typically, the
blue channel extracted from a canopy photograph. Please see \code{\link[=read_caim]{read_caim()}}
and \code{\link[=normalize]{normalize()}}.}

\item{sky}{An object of class \linkS4class{SpatRaster} produced with
\code{\link[=fit_coneshaped_model]{fit_coneshaped_model()}}, \code{\link[=fit_trend_surface]{fit_trend_surface()}}, \code{\link[=fit_cie_sky_model]{fit_cie_sky_model()}}, or
\code{\link[=ootb_sky_reconstruction]{ootb_sky_reconstruction()}}. It also support a numeric vector of length
one. For instance, it could be a value obtained with a combination of
\code{\link[=extract_sky_points]{extract_sky_points()}} and \code{\link[=extract_dn]{extract_dn()}}. The latter can be understood as
modelling the sky with a plane.}

\item{g}{\linkS4class{SpatRaster} built with \code{\link[=sky_grid_segmentation]{sky_grid_segmentation()}} or
\code{\link[=chessboard]{chessboard()}}.}

\item{intercept, slope}{Numeric vector of length one. These are linear
function coefficients.}

\item{w}{Numeric vector of length one. Weighting parameter from
\insertCite{Diaz2018;textual}{rcaiman}'s Equation 1. See \code{\link[=thr_mblt]{thr_mblt()}}}
}
\value{
An object of class \linkS4class{SpatRaster} with values \code{0} and \code{1}.
}
\description{
Cells without sky pixels are the so-called null cells. This type of cells are
mathematically intractable by models typically used to obtain canopy metrics.
This function find sky pixels using increase in number of null cells as the
stopping criteria.
}
\details{
The arguments \code{sky}, \code{intercept}, \code{slope}, and \code{w} are passed to \code{\link[=thr_mblt]{thr_mblt()}}
whose output is in turn passed to \code{\link[=apply_thr]{apply_thr()}} along with \code{r}. As a result,
\code{r} is binarized and used along with \code{g} to compute the number of null cells.
The process is repeated but increasing \code{w} in steps of 0.05 as long as
the number of null cells remains constant.
}
\examples{
\dontrun{
caim <- read_caim()
r <- caim$Blue \%>\% normalize()
caim <- normalize(caim, 0, 20847, TRUE)
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)
m <- !is.na(z)
bin <- ootb_obia(caim, z, a, m, HSV(239, 0.85, 0.5), gamma = NULL)
g <- sky_grid_segmentation(z, a, 3)
sky_points <- extract_sky_points(r, bin, g,
                                 dist_to_plant = 5,
                                 min_raster_dist = 5)
rl <- extract_rl(r, z, a, sky_points)
model <- fit_coneshaped_model(rl$sky_points)
summary(model$model)

sky <- model$fun(z, a)
sky <- fit_trend_surface(sky, z, a, !is.na(z))$image
plot(r/sky)

x <- predict(model$model)
y <- predict(model$model) + model$model$residuals
mblt <- coefficients(lm(x~y))

g <- sky_grid_segmentation(z, a, 10)
bin <- find_sky_pixels_nonnull(r, sky, g, mblt[1], mblt[2], w = 0.1)
plot(bin)
}
}
\seealso{
Other Tool Functions: 
\code{\link{colorfulness}()},
\code{\link{correct_vignetting}()},
\code{\link{defuzzify}()},
\code{\link{extract_dn}()},
\code{\link{extract_feature}()},
\code{\link{extract_rl}()},
\code{\link{extract_sky_points_simple}()},
\code{\link{extract_sky_points}()},
\code{\link{extract_sun_coord}()},
\code{\link{find_sky_pixels}()},
\code{\link{masking}()},
\code{\link{optim_normalize}()},
\code{\link{percentage_of_clipped_highlights}()},
\code{\link{read_bin}()},
\code{\link{read_caim_raw}()},
\code{\link{read_caim}()},
\code{\link{write_bin}()},
\code{\link{write_caim}()}
}
\concept{Tool Functions}
