% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_trend_surface.R
\name{fit_trend_surface}
\alias{fit_trend_surface}
\title{Fit a trend surface to sky digital numbers}
\usage{
fit_trend_surface(r, z, a, bin, filling_source = NULL, np = 6)
}
\arguments{
\item{r}{\linkS4class{SpatRaster}. A normalized greyscale image. Typically,
the blue channel extracted from a canopy photograph. Please see
\code{\link{read_caim}} and \code{\link{normalize}}.}

\item{z}{\linkS4class{SpatRaster} built with \code{\link{zenith_image}}.}

\item{a}{\linkS4class{SpatRaster} built with \code{\link{azimuth_image}}.}

\item{bin}{\linkS4class{SpatRaster}. This should be a preliminary
binarization of \code{r} useful for masking pixels that are very likely
to be pure sky pixels.}

\item{filling_source}{\linkS4class{SpatRaster}. An actual or reconstructed
above-canopy image to complement the sky pixels detected through the gaps
of \code{r}. If an incomplete above-canopy image is available, non-sky
pixels should be turned \code{NA} or they will be considered as sky pixels
erroneously. A photograph taken immediately after or before taking \code{r}
under the open sky with the same equipment and configuration is a very good
option but not recommended under fleeting clouds. The orientation relative
to the North must be the same as for \code{r}. If it is set to \code{NULL}
(default), only sky pixels from \code{r} will be used as input.}

\item{np}{
degree of polynomial surface
}
}
\value{
A list with an object of class \linkS4class{SpatRaster} and of class
  \code{trls} (see \code{\link[spatial]{surf.ls}}).
}
\description{
Fit a trend surface using \code{\link[spatial]{surf.ls}} as workhorse
function.
}
\details{
This function is meant to be used after \code{\link{fit_coneshaped_model}}.

A short explanation of this function can be found on
\insertCite{Diaz2018;textual}{rcaiman}, under the heading \emph{Estimation of
the sky DN as a previous step for our method}, after the explanation of the
\code{\link{fit_coneshaped_model}}.

If you use this function in your research, please cite
\insertCite{Diaz2018;textual}{rcaiman} in addition to this package.
}
\examples{
\dontrun{
path <- system.file("external/DSCN4500.JPG", package = "rcaiman")
caim <- read_caim(path, c(1280, 960) - 745, 745 * 2, 745 * 2)
z <- zenith_image(ncol(caim), lens("Nikon_FCE9"))
a <- azimuth_image(z)
r <- gbc(caim$Blue)
g <- sky_grid_segmentation(z, a, 10)
bin <- find_sky_pixels(r, z, a)
sky_points <- extract_sky_points(r, bin, g)
sky_points <- extract_rl(r, z, a, sky_points, NULL)
model <- fit_coneshaped_model(sky_points$sky_points)
sky_cs <- model$fun(z, a)
m <- mask_hs(z, 0, 80)
sky <- fit_trend_surface(r, z, a, bin, filling_source = sky_cs)
plot(sky$image)
}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{thr_image}}

Other Sky Reconstruction Functions: 
\code{\link{cie_sky_model_raster}()},
\code{\link{fit_cie_sky_model}()},
\code{\link{fit_coneshaped_model}()},
\code{\link{fix_reconstructed_sky}()},
\code{\link{interpolate_sky_points}()},
\code{\link{ootb_sky_reconstruction}()}
}
\concept{Sky Reconstruction Functions}
