% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_bin.R
\name{write_bin}
\alias{write_bin}
\title{Write binarized images}
\usage{
write_bin(bin, path)
}
\arguments{
\item{bin}{\linkS4class{RasterLayer}.}

\item{path}{Character vector of length one. Path for writing the image.}
}
\value{
No return value. Called for side effects.
}
\description{
Wrapper functions for \code{\link[raster]{writeRaster}}.
}
\examples{
\dontrun{
z <- zenith_image(1000, lens())
m <- !is.na(z)
my_file <- file.path(tmpDir(), "mask")
write_bin(m, my_file)
extension(my_file) <- "tif"
m_from_disk <- read_bin(my_file)
plot(m - m_from_disk)
}
}
\seealso{
\code{\link{read_bin}}

Other Tools functions: 
\code{\link{apply_thr}()},
\code{\link{extract_feature}()},
\code{\link{gbc}()},
\code{\link{masking}()},
\code{\link{normalize}()},
\code{\link{read_bin}()},
\code{\link{read_caim}()},
\code{\link{regional_thresholding}()},
\code{\link{write_caim}()}
}
\concept{Tools functions}
