% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproject_to_equidistant.R
\name{reproject_to_equidistant}
\alias{reproject_to_equidistant}
\alias{reproject_to_equidistant,RasterLayer-method}
\alias{reproject_to_equidistant,RasterStackBrick-method}
\title{Reproject to equidistant}
\usage{
reproject_to_equidistant(r, z, a, radius = 745)

\S4method{reproject_to_equidistant}{RasterLayer}(r, z, a, radius = 745)

\S4method{reproject_to_equidistant}{RasterStackBrick}(r, z, a, radius = 745)
}
\arguments{
\item{r}{\linkS4class{Raster}. Only methods for images with one or three
layers have been implemented.}

\item{z}{\linkS4class{RasterLayer}. The result of a call to
\code{\link{zenith_image}}.}

\item{a}{\linkS4class{RasterLayer}. The result of a call to
\code{\link{azimuth_image}}.}

\item{radius}{Numeric integer of length one. Radius of the reprojected
hemispherical image.}
}
\description{
Reproject to equidistant
}
\examples{
\dontrun{
caim <- read_caim()
caim <- normalize(caim, 0, 255)
z <- zenith_image(ncol(caim), lens("Nikon_FCE9"))
a <- azimuth_image(z)
bin <- apply_thr(caim$Blue, 0.5)
bin_equi <- reproject_to_equidistant(bin, z, a, radius = 400)
bin_equi <- apply_thr(bin_equi, 0.5)
plot(bin_equi)
# use write_bin(bin, "path\file_name") to have a file ready
# for calculating LAI with CIMES, GLA, CAN-EYE, etc.
}
}
\seealso{
Other Lens functions: 
\code{\link{azimuth_image}()},
\code{\link{calc_diameter}()},
\code{\link{calc_zenith_raster_coordinates}()},
\code{\link{calibrate_lens}()},
\code{\link{expand_noncircular}()},
\code{\link{lens}()},
\code{\link{test_lens_coef}()},
\code{\link{zenith_image}()}
}
\concept{Lens functions}
