% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countyExampleData.R
\docType{data}
\name{countyExample}
\alias{countyExample}
\alias{county}
\alias{ACS}
\alias{knots}
\title{U.S. Legal/Statistical Area Data}
\format{
countyExample contains 3 objects:
  \describe{
    \item{county}{A SpatialPolygonsDataFrame containing 3109 areas. For each
     areal unit, the following data are defined}
    \describe{
       \item{GEO_ID}{identifier for legal/statistical area}
       \item{STATE}{state containing the legal/statistical area}
       \item{NAME}{name of the legal/statistical area } 
       \item{LSAD}{legal/statistical area description} 
       \item{SHAPE_AREA}{area of the county in square meters.}
       \item{SHAPE_LEN}{perimeter of the county in meters.}
    }
   \item{ACS}{A 3109x2 matrix containing the public-use American Community
              Survey (ACS) 2013 5-year estimated county-level median 
              household income and its variance.}
   \describe{
      \item{LogMedianIncome}{log of the estimated median household income.}
      \item{VarianceLMI}{approximate variance of the log median 
                         household income (using the Delta method).}
   }
   \item{knots}{A 75x2 matrix of knots spanning the county data.}
   \describe{
      \item{x}{x coordinate}
      \item{y}{y coordinate}
   }
 }
}
\usage{
data(countyExample)
}
\description{
The U.S. legal/statistical areas, their median household income, and a
  matrix of knots provided only to facilitate illustrative examples.
}
\references{
U.S. Census Bureau. 
  2013-2017 American Community Survey 5-year Estimates; 
  generated by Jonathan Bradley; using American FactFinder.
}
\keyword{datasets}
