% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oceanExampleData.R
\docType{data}
\name{oceanExample}
\alias{oceanExample}
\alias{ocean}
\alias{oceanKnots}
\title{Ocean Color Observations}
\format{
oceanExample contains 2 objects:
  \describe{
   \item{ocean}{A SpatialPointsDataFrame containing 5255 points
                containing the following 6 columns:}
   \describe{
     \item{X1}{intercept}
     \item{X2}{ROMS ocean model output for chlorophyll}
     \item{X3}{ROMS ocean model output for sea surface temperature} 
     \item{X4}{ROMS ocean model output for Sea Surface Height (SSH)} 
     \item{CHA}{SeaWiFs satellite ocean color data. }
     \item{sigma2}{sample variance}
   }
   \item{oceanKnots}{A 170x2 matrix of knots in long/lat for the region
    spanned by data set ocean}
 }
}
\usage{
data(oceanExample)
}
\description{
This dataset is a sample from SeaWiFS Ocean Color Satellite Observations
 taken over the coastal Gulf of Alaska from 1998 to 2001 and ROMS Ocean Model.
 Data are provided only to facilitate illustrative examples.
}
\references{
Leeds, W.B., Wikle, C.K., and Fiechter, J. (2014). 
  Emulator-assisted reduced-rank ecological data assimilation for
  multivariate dynamical spatio-temporal processes. 
  Statistical Methodology, 17, 126--138.

  Wikle, C. K., Milliff, R. F., Herbei, R., and Leeds, W. B. (2013). 
  Modern statistical methods in oceanography: A hierarchical perspective. 
  Statistical Science, 28, 466-486.
}
\keyword{datasets}
