% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc.R
\name{subsample}
\alias{subsample}
\title{Generates subsamples.}
\usage{
subsample(n, m, B)
}
\arguments{
\item{n}{The sample size.}

\item{m}{Subsample size (an integer lower or equal than \code{n}).}

\item{B}{Number of sample splits.}
}
\value{
Matrix with the indices of the subsamples drawn in each column.
}
\description{
Generates subsamples.
}
\details{
Generates \code{m}-element subsamples drawn \eqn{\lfloor\frac{{n}}{{m}}\rfloor}{floor(n/m)} times
from \code{1,...,n} independently without replacement; such subsampling is repeated \code{B} times.
}
\examples{
subsample(10,5,2)
subsample(10,3,10)
}
\references{
R. Baranowski, P. Fryzlewicz (2015), Ranking Based Variable Selection, in submission (\url{http://personal.lse.ac.uk/baranows/rbvs/rbvs.pdf)}).
}

