% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_palettes.R
\name{set_palette}
\alias{set_palette}
\title{Set palettes for various plot attributes}
\usage{
set_palette(
  fig,
  discrete_color = NULL,
  discrete_alpha = NULL,
  continuous_color = NULL,
  continuous_alpha = NULL,
  discrete_glyph = NULL,
  discrete_fill_color = NULL,
  discrete_line_color = NULL,
  discrete_text_color = NULL,
  discrete_fill_alpha = NULL,
  discrete_line_alpha = NULL,
  discrete_text_alpha = NULL,
  discrete_line_dash = NULL,
  discrete_line_width = NULL,
  discrete_size = NULL,
  continuous_glyph = NULL,
  continuous_fill_color = NULL,
  continuous_line_color = NULL,
  continuous_text_color = NULL,
  continuous_fill_alpha = NULL,
  continuous_line_alpha = NULL,
  continuous_text_alpha = NULL,
  continuous_line_dash = NULL,
  continuous_line_width = NULL,
  continuous_size = NULL
)
}
\arguments{
\item{fig}{figure to update theme palettes for}

\item{discrete_color}{a discrete color palette to override the theme (see details)}

\item{discrete_alpha}{a discrete alpha palette to override the theme (see details)}

\item{continuous_color}{a continuous color palette to override the theme (see details)}

\item{continuous_alpha}{a continuous alpha palette to override the theme (see details)}

\item{discrete_glyph}{a discrete glyph palette to override the theme}

\item{discrete_fill_color}{a discrete fill_color palette to override the theme}

\item{discrete_line_color}{a discrete line_color palette to override the theme}

\item{discrete_text_color}{a discrete text_color palette to override the theme}

\item{discrete_fill_alpha}{a discrete fill_alpha palette to override the theme}

\item{discrete_line_alpha}{a discrete line_alpha palette to override the theme}

\item{discrete_text_alpha}{a discrete text_alpha palette to override the theme}

\item{discrete_line_dash}{a discrete line_dash palette to override the theme}

\item{discrete_line_width}{a discrete line_width palette to override the theme}

\item{discrete_size}{a discrete size palette to override the theme}

\item{continuous_glyph}{a continuous glyph palette to override the theme}

\item{continuous_fill_color}{a continuous fill_color palette to override the theme}

\item{continuous_line_color}{a continuous line_color palette to override the theme}

\item{continuous_text_color}{a continuous text_color palette to override the theme}

\item{continuous_fill_alpha}{a continuous fill_alpha palette to override the theme}

\item{continuous_line_alpha}{a continuous line_alpha palette to override the theme}

\item{continuous_text_alpha}{a continuous text_alpha palette to override the theme}

\item{continuous_line_dash}{a continuous line_dash palette to override the theme}

\item{continuous_line_width}{a continuous line_width palette to override the theme}

\item{continuous_size}{a continuous size palette to override the theme}
}
\description{
Set palettes for various plot attributes
}
\details{
Palettes specified in this function will override the existing theme and apply the specified attributes when they are not otherwise explicitly specified in a layer function.  See the contents of \code{bk_default_theme} for an example of the theme elements this will update.  As a convenience, if you use \code{discrete_color}, the palette will apply to all the \code{discrete_***_color} attributes unless those are explicitly specified also.  The same pattern is true for \code{discrete_alpha}, \code{continuous_color}, and \code{continuous_alpha}.  For specifying discrete color palettes, the easiest thing to do is use \code{\link{pal_color}} with a vector of colors you want to use in the palette.
}
\examples{
figure() \%>\%
  ly_points(Sepal.Length, Sepal.Width, data = iris,
    color = Species, glyph = Species) \%>\%
  set_palette(discrete_color = pal_color(c("red", "blue", "green")))

}
