% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fig_tool.R
\name{tool_wheel_zoom}
\alias{tool_wheel_zoom}
\title{Add "wheel_zoom" tool to a Bokeh figure}
\usage{
tool_wheel_zoom(fig, dimensions = "both")
}
\arguments{
\item{fig}{figure to modify}

\item{dimensions}{a vector specifying whether the wheel_zoom tool should zoom with respect to the x axis ("width") and the y axis ("height") or "both"}
}
\description{
Add "wheel_zoom" tool to a Bokeh figure
}
\note{
Tools can be easily specified as a vector of tool names in the \code{tools} argument when instantiating a \code{\link{figure}}.  In this case, they are added with defaults.  Explicitly calling these \code{tool_} functions will manually add the tool to a figure and allow additional specification of parameters.
}
\examples{
\donttest{
# only zoom on x axis
figure() \%>\% ly_points(1:10) \%>\%
 tool_wheel_zoom(dimensions = "height")
}
}
\seealso{
Other tools: 
\code{\link{tool_box_select}()},
\code{\link{tool_box_zoom}()},
\code{\link{tool_crosshair}()},
\code{\link{tool_hover}()},
\code{\link{tool_lasso_select}()},
\code{\link{tool_pan}()},
\code{\link{tool_reset}()},
\code{\link{tool_resize}()},
\code{\link{tool_save}()},
\code{\link{tool_tap}()}
}
\concept{tools}
