% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_image.R
\name{ly_image}
\alias{ly_image}
\title{Add an "image" layer to a Bokeh figure}
\usage{
ly_image(fig, z, rows, byrow = TRUE, x = 0, y = 0, dw = 1, dh = 1,
  palette = "Spectral10", dilate = FALSE, lname = NULL, lgroup = NULL,
  visible = TRUE)
}
\arguments{
\item{fig}{figure to modify}

\item{z}{matrix or vector of image values}

\item{rows}{if \code{z} is a vector, how many rows should be used in treating it as a matrix}

\item{byrow}{if \code{z} is a vector, should it be turned into a matrix by row}

\item{x}{lower left x coordinates}

\item{y}{lower left y coordinates}

\item{dw}{image width distances}

\item{dh}{image height distances}

\item{palette}{name of color palette to use for color ramp (see \href{http://bokeh.pydata.org/en/latest/docs/reference/palettes.html}{here} for acceptable values)}

\item{dilate}{logical - whether to dilate pixel distance computations when drawing}

\item{lname}{layer name}

\item{lgroup}{layer group}

\item{visible}{should the layer be visible?}
}
\description{
Draws a grid of rectangles with colors corresponding to the values in \code{z}
}
\examples{
\donttest{
p <- figure(xlim = c(0, 1), ylim = c(0, 1), title = "Volcano") \%>\%
  ly_image(volcano) \%>\%
  ly_contour(volcano)
p
}
}
\seealso{
Other layer functions: \code{\link{ly_abline}},
  \code{\link{ly_annular_wedge}}, \code{\link{ly_annulus}},
  \code{\link{ly_arc}}, \code{\link{ly_bar}},
  \code{\link{ly_bezier}}, \code{\link{ly_boxplot}},
  \code{\link{ly_contour}}, \code{\link{ly_crect}},
  \code{\link{ly_curve}}, \code{\link{ly_density}},
  \code{\link{ly_hist}}, \code{\link{ly_image_url}},
  \code{\link{ly_lines}}, \code{\link{ly_map}},
  \code{\link{ly_multi_line}}, \code{\link{ly_oval}},
  \code{\link{ly_patch}}, \code{\link{ly_points}},
  \code{\link{ly_polygons}}, \code{\link{ly_quadratic}},
  \code{\link{ly_quantile}}, \code{\link{ly_ray}},
  \code{\link{ly_rect}}, \code{\link{ly_segments}},
  \code{\link{ly_text}}, \code{\link{ly_wedge}}
}

