% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fig_gmap.R
\name{gmap_style}
\alias{gmap_style}
\title{Get a Google Map Style}
\usage{
gmap_style(name)
}
\arguments{
\item{name}{name of map style to retrieve (see details)}
}
\description{
Get a Google Map Style
}
\details{
This function provides Google Maps themes that can be passed to the \code{map_style} argument of \code{\link{gmap}}.  Currently the most popular styles from \url{https://snazzymaps.com} are available.  You can also visit this site or others to specify a custom \code{map_style}.  Available styles are: "subtle_grayscale", "shades_of_grey", "blue_water", "pale_dawn", "blue_essence", "apple_mapsesque", "midnight_commander", "light_monochrome", "paper", "retro", "flat_map", "cool_grey".
}
\examples{
\donttest{
# custom map style
gmap(lat = 40.74, lng = -73.95, zoom = 11,
  width = 600, height = 600,
  map_style = gmap_style("blue_water"))
}
\dontrun{
gmap(title = "NYC taxi pickups January 2013",
  lat = 40.74, lng = -73.95, zoom = 11,
  map_type = "roadmap", width = 1000, height = 800) \%>\%
  ly_hexbin(nyctaxihex, alpha = 0.5,
    palette = "Spectral10", trans = log, inv = exp)
}
}
\seealso{
\code{\link{gmap}}
}

