% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biorxiv_published.R
\name{biorxiv_published}
\alias{biorxiv_published}
\title{Retrieve details of published articles with bioRxiv preprints}
\usage{
biorxiv_published(
  from = NULL,
  to = NULL,
  limit = 100,
  skip = 0,
  format = "list"
)
}
\arguments{
\item{from}{(date) The date from when details of published articles should
be collected. Date must be supplied in \code{YYYY-MM-DD} format. Default: \code{NULL}}

\item{to}{(date) The date until when details of published articles should
be collected. Date must be supplied in \code{YYYY-MM-DD} format. Default: \code{NULL}}

\item{limit}{(integer) The maximum number of results to return. Not
relevant when querying a doi. Default: \code{100}}

\item{skip}{(integer) The number of results to skip in a query.
Default: \code{0}}

\item{format}{(character) Return data in list \code{list}, json \code{json} or data
frame \code{df} format. Default: \code{list}}
}
\description{
Retrieve details of published articles with bioRxiv preprints
}
\examples{
\donttest{

# Get details of articles published between 2018-01-01 and 2018-01-10
# By default, only the first 100 records are returned
biorxiv_published(from = "2018-01-01", to = "2018-01-10")

# Set a limit to return more than 100 records
biorxiv_published(from = "2018-01-01", to = "2018-01-10", limit = 200)

# Set limit as "*" to return all records
biorxiv_published(from = "2018-01-01", to = "2018-01-10", limit = "*")

# Skip the first 100 records
biorxiv_published(from = "2018-01-01", to = "2018-01-10",
                  limit = 200, skip = 100)

# Specify the format to return data
biorxiv_published(from = "2018-01-01", to = "2018-01-10", format = "df")
}
}
