% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.r
\name{bdiv_clusters}
\alias{bdiv_clusters}
\title{Define sample PAM clusters from beta diversity.}
\usage{
bdiv_clusters(
  biom,
  bdiv = "Bray-Curtis",
  weighted = TRUE,
  tree = NULL,
  k = 5,
  ...
)
}
\arguments{
\item{biom}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.
Any value accepted by \code{\link[=as_rbiom]{as_rbiom()}} can also be given here.}

\item{bdiv}{Beta diversity distance algorithm(s) to use. Options are:
\code{"Bray-Curtis"}, \code{"Manhattan"}, \code{"Euclidean"},
\code{"Jaccard"}, and \code{"UniFrac"}. For \code{"UniFrac"}, a
phylogenetic tree must be present in \code{biom} or explicitly
provided via \verb{tree=}. Multiple/abbreviated values allowed.
Default: \code{"Bray-Curtis"}}

\item{weighted}{Take relative abundances into account. When
\code{weighted=FALSE}, only presence/absence is considered.
Multiple values allowed. Default: \code{TRUE}}

\item{tree}{A \code{phylo} object representing the phylogenetic
relationships of the taxa in \code{biom}. Only required when
computing UniFrac distances. Default: \code{biom$tree}}

\item{k}{Number of clusters. Default: \code{5L}}

\item{...}{Passed on to \code{cluster::pam()}.}
}
\value{
A numeric factor assigning samples to clusters.
}
\description{
Define sample PAM clusters from beta diversity.
}
\examples{
    library(rbiom)
    
    biom <- rarefy(hmp50)
    biom$metadata$bray_cluster <- bdiv_clusters(biom)
    
    pull(biom, 'bray_cluster')[1:10]
    
    bdiv_ord_plot(biom, stat.by = "bray_cluster")
}
\seealso{
Other beta_diversity: 
\code{\link{bdiv_boxplot}()},
\code{\link{bdiv_corrplot}()},
\code{\link{bdiv_heatmap}()},
\code{\link{bdiv_ord_plot}()},
\code{\link{bdiv_ord_table}()},
\code{\link{bdiv_stats}()},
\code{\link{bdiv_table}()},
\code{\link{distmat_stats}()}

Other clustering: 
\code{\link{taxa_clusters}()}
}
\concept{beta_diversity}
\concept{clustering}
