% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panther.R
\name{rba_panther_homolog}
\alias{rba_panther_homolog}
\title{Search PANTHER for Homologs of Gene(s)}
\usage{
rba_panther_homolog(genes, organism, type = "P", target_organisms = NULL, ...)
}
\arguments{
\item{genes}{Character vector of genes identifiers with maximum length of
10 or only one if seq_pos is supplied. Can be any of: Ensemble gene ID,
Ensemble protein ID, Ensemble transcript ID, Entrez gene ID, gene symbol,
NCBI GI, HGNC ID, International protein index ID, NCBI UniGene ID,
UniProt accession and/or UniProt ID.}

\item{organism}{(numeric) NCBI taxon ID of the organism of your supplied
genes. run \code{\link{rba_panther_info}} with argument
'what = "organisms"' to get a list of PANTHER's supported organisms.}

\item{type}{Homolog types to return. either "P" (default) for paralogs,
"X" for horizontal gene transfer and "LDX" for diverged horizontal gene
transfer.}

\item{target_organisms}{(numeric) NCBI taxon ID(s) to filter the results.
run \code{\link{rba_panther_info}} with argument 'what = "organisms"' to
get a list of PANTHER's supported organisms.
For Paralog, target organism and organism should be the same; Otherwise,
the target organism should be different from the input organism.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A dataframe with homologs information.
}
\description{
Using this function you can search and retrieve homolog of given gene(s).
}
\section{Corresponding API Resources}{

 "GET http://www.pantherdb.org/services/oai/pantherdb/ortholog/homologOther"
}

\examples{
\donttest{
rba_panther_homolog("OR4F5", organism = 9606, type = "P")
}

}
\references{
\itemize{
  \item Huaiyu Mi, Dustin Ebert, Anushya Muruganujan, Caitlin Mills,
  Laurent-Philippe Albou, Tremayne Mushayamaha, Paul D Thomas, PANTHER
  version 16: a revised family classification, tree-based classification
  tool, enhancer regions and extensive API, Nucleic Acids Research,
  Volume 49, Issue D1, 8 January 2021, Pages D394–D403,
  https://doi.org/10.1093/nar/gkaa1106
  \item \href{http://www.pantherdb.org/services/details.jsp}{PANTHER
  Services Details}
  \item
  \href{http://www.pantherdb.org/publications.jsp#HowToCitePANTHER}{Citations
  note on PANTHER website}
  }
}
\seealso{
Other "PANTHER": 
\code{\link{rba_panther_enrich}()},
\code{\link{rba_panther_family}()},
\code{\link{rba_panther_info}()},
\code{\link{rba_panther_mapping}()},
\code{\link{rba_panther_ortholog}()},
\code{\link{rba_panther_tree_grafter}()}
}
\concept{"PANTHER"}
