% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panther.R
\name{rba_panther_family}
\alias{rba_panther_family}
\title{Get PANTHER Families and Sub-Families}
\usage{
rba_panther_family(id, what, target_organisms = NULL, ...)
}
\arguments{
\item{id}{Panther family id.}

\item{what}{What to retrieve? One of: \itemize{
\item "ortholog": Orthologs ('LDO' for least diverged and 'O' for more
  diverged).
\item "msa": Multiple Sequence Alignment Information,
\item "tree": Tree topology and nodes attributes.
}}

\item{target_organisms}{(numeric) NCBI taxon ID(s) to filter the results.
run \code{\link{rba_panther_info}} with argument 'what = "organisms"' to
get a list of PANTHER's supported organisms.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
For trees a list and otherwise a data frame with the requested
  family's information.
}
\description{
Using this function, you can retrieve Orthologs, MSA or Tree topology
  information of a given PANTHER family.
}
\section{Corresponding API Resources}{

 "GET http://www.pantherdb.org/services/oai/pantherdb/familyortholog"
 \cr "GET http://www.pantherdb.org/services/oai/pantherdb/familymsa"
 \cr "GET http://www.pantherdb.org/services/oai/pantherdb/treeinfo"
}

\examples{
\donttest{
rba_panther_family("PTHR10000", what = "ortholog")
}

}
\references{
\itemize{
  \item Mi, H., Muruganujan, A., Ebert, D., Huang, X., & Thomas, P. D.
  (2019). PANTHER version 14: more genomes, a new PANTHER GO-slim and
  improvements in enrichment analysis tools. Nucleic acids research, 47(D1),
  D419-D426.
  \item Mi, H., Muruganujan, A., Huang, X., Ebert, D., Mills, C., Guo, X.,
  & Thomas, P. D. (2019). Protocol Update for large-scale genome and gene
  function analysis with the PANTHER classification system (v. 14.0).
  Nature protocols, 14(3), 703-721.
  \item \href{http://www.pantherdb.org/services/details.jsp}{PANTHER
  Services Details}
  }
}
\seealso{
Other "PANTHER": 
\code{\link{rba_panther_enrich}()},
\code{\link{rba_panther_homolog}()},
\code{\link{rba_panther_info}()},
\code{\link{rba_panther_mapping}()},
\code{\link{rba_panther_ortholog}()},
\code{\link{rba_panther_tree_grafter}()}
}
\concept{"PANTHER"}
