% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichr.R
\name{rba_enrichr_gene_map}
\alias{rba_enrichr_gene_map}
\title{Find Enrichr Terms That Contain a Given Gene}
\usage{
rba_enrichr_gene_map(gene, catagorize = FALSE, organism = "human", ...)
}
\arguments{
\item{gene}{character: An Entrez gene symbol.}

\item{catagorize}{logical: Should the category informations be included?}

\item{organism}{(default = "human") Which model organism version of Enrichr
to use? Available options are: "human", (H. sapiens & M. musculus),
"fly" (D. melanogaster), "yeast" (S. cerevisiae), "worm" (C. elegans)
and "fish" (D. rerio).}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
a list containing the search results of your supplied gene.
}
\description{
This function will search the gene and retrieve a list of Enrichr
  Terms that contains that gene.
}
\section{Corresponding API Resources}{

 "GET https://maayanlab.cloud/Enrichr/genemap"
}

\examples{
\donttest{
rba_enrichr_gene_map(gene = "p53")
}
\donttest{
rba_enrichr_gene_map(gene = "p53", catagorize = TRUE)
}

}
\references{
\itemize{
  \item Chen EY, Tan CM, Kou Y, Duan Q, Wang Z, Meirelles GV, Clark NR,
  Ma'ayan A. Enrichr: interactive and collaborative HTML5 gene list
  enrichment analysis tool. BMC Bioinformatics. 2013;128(14).
  \item Kuleshov MV, Jones MR, Rouillard AD, Fernandez NF, Duan Q, Wang Z,
  Koplev S, Jenkins SL, Jagodnik KM, Lachmann A, McDermott MG, Monteiro CD,
  Gundersen GW, Ma'ayan A. Enrichr: a comprehensive gene set enrichment
  analysis web server 2016 update. Nucleic Acids Research. 2016; gkw377.
  \item \href{https://maayanlab.cloud/Enrichr/help#api}{Enrichr API
  Documentation}
  }
}
\seealso{
Other "Enrichr": 
\code{\link{rba_enrichr_add_list}()},
\code{\link{rba_enrichr_enrich}()},
\code{\link{rba_enrichr_libs}()},
\code{\link{rba_enrichr_view_list}()},
\code{\link{rba_enrichr}()}
}
\concept{"Enrichr"}
