% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_orthology}
\alias{rba_reactome_orthology}
\title{Get Orthologous (Computationally Inferred) Events}
\usage{
rba_reactome_orthology(event_ids, species_dbid, ...)
}
\arguments{
\item{event_ids}{Human Reactome event ID(s) to retrieve their orthologous
events.}

\item{species_dbid}{Reactome database ID (DbId) of the target species. (e.g
Mus musculus is 48892). Refer to
 \code{\link{rba_reactome_species}} or
 \href{https://reactome.org/content/schema/objects/Species}{Reactome
 Data Schema: Entries: Species}.}

\item{...}{rbioapi option(s). Refer to \code{\link{rba_options}}'s
arguments documentation for more information on available options.}
}
\value{
List containing found Orthologous event(s) in your provided species
  and their pertinent information.
}
\description{
Reactome incorporate manually curated human reactions and PANTHER's
  protein homology data to Computationally infer events in other eukaryotic
  species.
}
\details{
In version 73 (11 June 2020), using an orthology-based approach,
  Homo sapiens events was projected to 18,654 orthologous pathways (with
  81,835 orthologous proteins) in 15 non-human species.
  \cr Refer to \href{https://reactome.org/documentation/inferred-events}{
  Reactome Computationally Inferred Events} for more information.
}
\section{Corresponding API Resources}{

 "POST https://reactome.org/ContentService/data/orthologies/ids/
   species/{speciesId}"
}

\examples{
\donttest{
rba_reactome_orthology(event_ids = c("R-HSA-6799198", " R-HSA-72764"),
    species_dbid = 49633)
}

}
\references{
\itemize{
  \item Jassal B, Matthews L, Viteri G, Gong C, Lorente P, Fabregat A,
  Sidiropoulos K, Cook J, Gillespie M, Haw R, Loney F, May B, Milacic M,
  Rothfels K, Sevilla C, Shamovsky V, Shorser S, Varusai T, Weiser J, Wu G,
  Stein L, Hermjakob H, D'Eustachio P. The reactome pathway knowledgebase.
  Nucleic Acids Res. 2020 Jan 8;48(D1):D498-D503. doi: 10.1093/nar/gkz1031.
  PubMed PMID: 31691815.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  }
}
\seealso{
\code{\link{rba_reactome_analysis_species}}
}
\concept{"Reactome Content Service - Orthology Related Queries"}
