% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhl_pagesearch.R
\name{bhl_pagesearch}
\alias{bhl_pagesearch}
\title{Search an item for pages containing the specified text}
\usage{
bhl_pagesearch(id, text, as = "table", key = NULL, ...)
}
\arguments{
\item{id}{(integer) BHL identifier of the item to be searched}

\item{text}{(character) the text for which to search}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"),
or parsed table ("table", default). Note that \code{as="table"} can give
different data format back depending on the function - for example,
sometimes a data.frame and sometimes a character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron}
as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\description{
Search an item for pages containing the specified text
}
\examples{
\dontrun{
bhl_pagesearch(22004, "dog")
bhl_pagesearch(22004, "dog", as = "json")
}
}
