% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhl_getauthormetadata.R
\name{bhl_getauthormetadata}
\alias{bhl_getauthormetadata}
\title{Get metadata about an author}
\usage{
bhl_getauthormetadata(
  id,
  id_type = "bhl",
  pubs = FALSE,
  as = "table",
  key = NULL,
  ...
)
}
\arguments{
\item{id}{(numeric) the identifier of an individual author}

\item{id_type}{(character) the type of identifier (bhl, biostor, viaf).
Default: "bhl"}

\item{pubs}{(logical) \code{TRUE} to return the subject's publications.
Default: \code{FALSE}}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"),
or parsed table ("table", default). Note that \code{as="table"} can give
different data format back depending on the function - for example,
sometimes a data.frame and sometimes a character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron}
as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\description{
Get metadata about an author
}
\details{
You may choose to include a list of the author's publications.
The BHLType element identifies the type of each publication (Title or Part).
}
\examples{
\dontrun{
bhl_getauthormetadata(87509)
bhl_getauthormetadata(87509, pubs = TRUE, verbose = TRUE)
bhl_getauthormetadata(87509, as = "json")
}
}
