% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhl_booksearch.R
\name{bhl_booksearch}
\alias{bhl_booksearch}
\title{Search for titles and items in BHL.}
\usage{
bhl_booksearch(title = NULL, lname = NULL, volume = NULL,
  edition = NULL, year = NULL, collectionid = NULL, language = NULL,
  as = "table", key = NULL, ...)
}
\arguments{
\item{title}{string to search for in the title (character)}

\item{lname}{last name to search for (character)}

\item{volume}{volume to search for (numeric)}

\item{edition}{edition to search for (character)}

\item{year}{year to search for, four characters, e.g, 1970 (numeric)}

\item{collectionid}{collection identifier to search for (numeric)}

\item{language}{language to search for (character)}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"),
or parsed table ("table", default). Note that \code{as="table"} can give
different data format back depending on the function - for example,
sometimes a data.frame and sometimes a character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron}
as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\description{
Search criteria includes title, author last name, volume, edition, year of
publication, subject, language code, and collection identifier. Valid
language codes and collection identifiers can be obtained from the
getlanguages and getcollections functions. If year of publication is
specified, it should be a 4-digit year. To execute a search, you must
supply at least a title, author last name, or collection identifier.
}
\note{
Use \code{\link[=bhl_getcollections]{bhl_getcollections()}} or \code{\link[=bhl_getlanguages]{bhl_getlanguages()}}
to get acceptable terms
}
\examples{
\dontrun{
bhl_booksearch(title='Selborne', lname='White', volume=2, edition='new',
   year=1825, collectionid=4, language='eng')
bhl_booksearch(title='evolution', year=2000, as='json')
bhl_booksearch('evolution', year=2000, as='xml')
bhl_booksearch('evolution', year=2000, as="list")
}
}
