% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhl_getauthorparts.R
\name{bhl_getauthorparts}
\alias{bhl_getauthorparts}
\title{Return a list of parts (articles, chapters, etc) associated with a given BHL
author identifier. Unless the identifier  for a particular BHL author record
is known in advance, this method should be used in combination	with the
AuthorSearch method.}
\usage{
bhl_getauthorparts(creatorid, as = "table", key = NULL, ...)
}
\arguments{
\item{creatorid}{BHL identifier for a particular author (numeric)}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"), or parsed table
("table", default). Note that \code{as="table"} can give different data format back
depending on the function - for example, sometimes a data.frame and sometimes a
character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron} as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Note: haven't seen examples for this function that work yet...
}
\examples{
\dontrun{
# bhl_getauthorparts(147)
# bhl_getauthorparts(39120, as='json')
# bhl_getauthorparts(39120, as='xml')
# bhl_getauthorparts(39120, as='list')
}
}

