\name{bhl_getlanguages}
\alias{bhl_getlanguages}
\title{Get a list of languages in which materials in BHL have been written.}
\usage{
bhl_getlanguages(format = "json", output = "list", key = NULL,
  callopts = list())
}
\arguments{
  \item{format}{either XML ('xml') or JSON ('json') format.
  If output='list', format is forced to equal 'json'}

  \item{output}{Return a list, raw json or xml, or parsed
  data (character).  Default: 'list'}

  \item{key}{your BHL API key, either enter, or loads from
  .Rprofile}

  \item{callopts}{Call options passed on to httr::GET.}
}
\description{
Get a list of languages in which materials in BHL have been
written.
}
\examples{
\dontrun{
bhl_getlanguages()
bhl_getlanguages(output='parsed')
bhl_getlanguages(output='raw')
bhl_getlanguages(output='raw', format='xml')
}
}

