% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_entity.R
\name{BlockEntity}
\alias{BlockEntity}
\alias{get_block_entity_data}
\alias{get_block_entity_value}
\alias{put_block_entity_data}
\alias{put_block_entity_value}
\title{Load and store BlockEntity NBT data}
\usage{
get_block_entity_data(x, z, dimension, db = default_db())

get_block_entity_value(x, z, dimension, db = default_db())

put_block_entity_data(values, x, z, dimension, db = default_db())

put_block_entity_value(value, x, z, dimension, db = default_db())
}
\arguments{
\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{db}{A bedrockdb object.}

\item{values}{A (named) list of list of NBT objects.}

\item{value}{A list of NBT objects.}
}
\value{
\code{get_block_entity_value()} returns a list of NBT objects.
\code{get_block_entity_data()} returns a named list of lists of NBT objects.
}
\description{
BlockEntity data (tag 49) holds a list of NBT values for
entity data associated with specific blocks.
}
\details{
\itemize{
\item \code{get_block_entity_value()} and \code{get_block_entity_data()} load BlockEntity
data from \code{db}. \code{get_block_entity_value()} loads data for a single chunk,
and \code{get_block_entity_data()} loads data for multiple chunks.
\item \code{put_block_entity_value()} and \code{put_block_entity_data()} store BlockEntity
data for one or multiple chunks into \code{db}.
}
}
