% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BchAddresses.R
\name{PubHash2BchAdr}
\alias{PubHash2BchAdr}
\title{Create BCH address from public key hash}
\usage{
PubHash2BchAdr(pubhash)
}
\arguments{
\item{pubhash}{\code{character}, the public key hash.}
}
\value{
\code{character}, the BCH address
}
\description{
This function returns the corresponding BCH address from a
hashed public key.
}
\references{
\url{https://en.bitcoin.it/wiki/Address}
}
\seealso{
Other BchAdresses: 
\code{\link{BCHADR-class}},
\code{\link{BTCADR-class}},
\code{\link{PubKey2PubHash}()},
\code{\link{base58CheckDecode}()},
\code{\link{base58CheckEncode}()},
\code{\link{concatHex}()},
\code{\link{decodeHex}()},
\code{\link{hash160}()},
\code{\link{hash256}()},
\code{\link{validBchAdr}()},
\code{\link{validBtcAdr}()}
}
\author{
Bernhard Pfaff
}
\concept{BchAdresses}
