% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbcb_get_market_expectations.R
\name{get_institutions_market_expectations}
\alias{get_institutions_market_expectations}
\title{Get market expectations sent by officially recognized Institutions that
contribute with expectations}
\usage{
get_institutions_market_expectations(
  indic = NULL,
  start_date = NULL,
  end_date = NULL,
  ...
)
}
\arguments{
\item{indic}{a character vector with economic indicators names.
They are case sensitive and don't forget the accents.}

\item{start_date}{series initial date.
Accepts ISO character formated date and \code{Date}.}

\item{end_date}{series final date.
Accepts ISO character formated date and \code{Date}.}

\item{...}{additional parameters to be passed to the API

\code{indic} argument must be one of indicators listed in Details.
Respecting the case, blank spaces and accents.

The \code{...} is to be used with API's parameters. \code{$top} to specify
the maximum number of rows to be returned, this returns the \code{$top} rows,
in chronological order. There is also \code{$skip} to ignore the first rows.}
}
\value{
A \code{data.frame} with the requested data.
}
\description{
Statistics of market expectations sent by institutions.
All statistics are computed based on expectations provided by many financial
institutions in Brazil: banks, funds, risk managers, so on and so forth.
These expections and its statistics are used to build the FOCUS Report weekly
released by the Brazilian Central Bank.
}
\details{
There are market expectations available for the following indicators:

\itemize{
\item Balança Comercial
\item Câmbio
\item Conta corrente
\item Dívida bruta do governo geral
\item Dívida líquida do setor público
\item IGP-DI
\item IGP-M
\item INPC
\item Investimento direto no país
\item IPA-DI
\item IPA-M
\item IPCA
\item IPCA Administrados
\item IPCA Alimentação no domicílio
\item IPCA Bens industrializados
\item IPCA Livres
\item IPCA Serviços
\item IPCA-15
\item IPC-FIPE
\item PIB Agropecuária
\item PIB Despesa de consumo da administração pública
\item PIB despesa de consumo das famílias
\item PIB Exportação de bens e serviços
\item PIB Formação Bruta de Capital Fixo
\item PIB Importação de bens e serviços
\item PIB Indústria
\item PIB Serviços
\item PIB Total
\item Produção industrial
\item Resultado nominal
\item Resultado primário
\item Selic
\item Taxa de desocupação
}

Check <https://olinda.bcb.gov.br/olinda/servico/Expectativas/versao/v1/documentacao#ExpectativasMercadoInstituicoes>
for more details
}
\examples{
\dontrun{
indic <- "IPCA"
x <- get_institutions_market_expectations(indic, `$top` = 10)

x <- get_institutions_market_expectations(`$top` = 20)
}

}
